/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class RPkgDescrBracketLevel
extends LinkedModeBracketLevel {
    public static LinkedModeBracketLevel.InBracketPosition createPosition(char c, IDocument document, int offset, int length, int sequence) {
        return switch (c) {
            case '(' -> new RoundBracketPosition(document, offset, length, sequence);
            case '{' -> new CurlyBracketPosition(document, offset, length, sequence);
            case '[' -> new SquareBracketPosition(document, offset, length, sequence);
            default -> throw new IllegalArgumentException("Invalid position type: " + c);
        };
    }

    public RPkgDescrBracketLevel(LinkedModeModel model, IDocument document, DocContentSections docContentSections, List<? extends LinkedPosition> positions, int mode) {
        super(model, document, docContentSections, positions, mode);
    }

    public static final class CurlyBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public CurlyBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }
    }

    public static final class RoundBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public RoundBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '(';
        }

        public char getCloseChar() {
            return ')';
        }
    }

    public static final class SquareBracketPosition
    extends LinkedModeBracketLevel.InBracketPosition {
        public SquareBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }
    }
}

