/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.eclipse.statet.internal.rj.servi.MXUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.servi.jmx.NodeConfigMXBean;
import org.eclipse.statet.rj.servi.node.RServiNodeConfig;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class MXNodeConfig
extends RServiNodeConfig
implements NodeConfigMXBean {
    private final PoolServer server;
    private @Nullable ObjectName jmName;

    public MXNodeConfig(PoolServer server) throws JMException {
        this.server = (PoolServer)ObjectUtils.nonNullAssert((Object)server);
    }

    public void initJM() throws JMException {
        ObjectName jmName;
        this.jmName = jmName = new ObjectName(this.server.getJMBaseName() + "type=Server.NodeConfig");
        ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmName);
    }

    public void disposeJM() throws JMException {
        ObjectName jmName = this.jmName;
        if (jmName != null) {
            this.jmName = null;
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(jmName);
        }
    }

    @Override
    public synchronized void setEnvironmentVariable(String name, @Nullable String value) {
        Map<String, String> variables = this.getEnvironmentVariables();
        if (value == null) {
            variables.remove(name);
        } else {
            variables.put(name, value);
        }
    }

    @Override
    public long getStartStopTimeoutMillis() {
        Duration timeout = this.getStartStopTimeout();
        return timeout != null ? timeout.toMillis() : -1L;
    }

    @Override
    public void setStartStopTimeoutMillis(long milliseconds) {
        Duration duration = milliseconds != -1L ? Duration.ofMillis(milliseconds) : null;
        this.setStartStopTimeout(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws OperationsException {
        MXNodeConfig mXNodeConfig = this;
        synchronized (mXNodeConfig) {
            MXUtils.validate(this);
            try {
                this.server.setNodeConfig(this);
            }
            catch (RjInvalidConfigurationException e) {
                throw new OperationsException(e.getMessage());
            }
        }
    }

    @Override
    public void loadActual() throws OperationsException {
        this.server.getNodeConfig(this);
    }

    @Override
    public void loadDefault() throws OperationsException {
        this.load(new RServiNodeConfig());
    }

    @Override
    public void loadSaved() throws OperationsException {
        MXUtils.load(this, this.server.getRJContext());
    }

    @Override
    public void save() throws OperationsException {
        MXUtils.save(this, this.server.getRJContext());
    }
}

