/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.setup;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.IRemoteEngineController;
import org.eclipse.statet.nico.core.runtime.IToolEventHandler;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.util.AbstractConsoleCommandHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class QuitHandler
extends AbstractConsoleCommandHandler
implements IToolEventHandler {
    @NonNullByDefault
    public org.eclipse.statet.jcommons.status.Status execute(String id, ConsoleService service, ToolCommandData data, ProgressMonitor m) {
        if (PlatformUI.getWorkbench().isClosing()) {
            ToolController controller = service.getController();
            if (controller != null) {
                if (service.getTool().isProvidingFeatureSet("org.eclipse.statet.nico/remote")) {
                    try {
                        ((IRemoteEngineController)controller).disconnect(m);
                        return org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS;
                    }
                    catch (StatusException statusException) {
                        // empty catch block
                    }
                }
                try {
                    controller.kill(m);
                    return org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS;
                }
                catch (StatusException statusException) {
                    // empty catch block
                }
            }
            return org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS;
        }
        List quitRunnables = (List)data.getRequired("scheduledQuitRunnables", List.class);
        if (quitRunnables.isEmpty()) {
            return org.eclipse.statet.jcommons.status.Status.OK_STATUS;
        }
        UIRunnable runner = new UIRunnable();
        runner.controller = service.getController();
        ToolProcess process = runner.controller.getTool();
        runner.dialogTitle = NLS.bind((String)Messages.TerminatingMonitor_title, (Object)process.getLabel(0));
        runner.dialogMessage = NLS.bind((String)Messages.TerminatingMonitor_message, (Object)process.getLabel(1));
        runner.dialogOptions = new String[]{Messages.TerminatingMonitor_WaitButton_label, Messages.TerminatingMonitor_ForceButton_label, Messages.TerminatingMonitor_CancelButton_label};
        UIAccess.getDisplay().syncExec((Runnable)runner);
        if (runner.result == 2) {
            runner.controller.cancelQuit();
        }
        return org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS;
    }

    private static class UIRunnable
    implements Runnable {
        private ToolController controller;
        private String dialogTitle;
        private String dialogMessage;
        private String[] dialogOptions;
        private volatile int result;

        private UIRunnable() {
        }

        @Override
        public void run() {
            IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow((boolean)true);
            MessageDialog dialog = new MessageDialog(window.getShell(), this.dialogTitle, null, this.dialogMessage, 3, this.dialogOptions, 0);
            this.result = dialog.open();
            if (this.result == 1) {
                try {
                    window.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            ProgressMonitor m = EStatusUtils.convert((IProgressMonitor)monitor, (int)1);
                            try {
                                controller.kill(m);
                            }
                            catch (StatusException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", Messages.TerminatingMonitor_Force_error_message, e.getTargetException()), 3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

