/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.statet.ecommons.debug.ui.config.EnhCommonTab;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

@NonNullByDefault
public class CommonTabForConsole
extends EnhCommonTab {
    private Button ansiEscSeqButton;

    public void createControl(Composite parent) {
        Layout layout;
        super.createControl(parent);
        Button button = CommonTabForConsole.findButton((Composite)this.getControl(), LaunchConfigurationsMessages.CommonTab_5);
        if (button != null) {
            button.setText(Messages.CommonTab_AllocateErrorLogConsole_label);
        } else {
            NicoUIPlugin.logWarning("Failed to add option to CommonTab.");
        }
        Group group = CommonTabForConsole.findGroup((Composite)this.getControl(), LaunchConfigurationsMessages.CommonTab_1);
        if (group != null && (layout = group.getLayout()) instanceof GridLayout) {
            GridLayout layout2 = (GridLayout)layout;
            LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
            Button button2 = new Button((Composite)group, 32);
            button2.setFont(button2.getParent().getFont());
            button2.setText(Messages.CommonTab_ProcessAnsiEscSequences_label);
            button2.setLayoutData((Object)new GridData(4, 4, true, false, layout2.numColumns, 1));
            button2.addSelectionListener((SelectionListener)new EnhCommonTab.UpdateOnChangeHandler((EnhCommonTab)this));
            this.ansiEscSeqButton = button2;
        } else {
            NicoUIPlugin.logWarning("Failed to add option to CommonTab.");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        configuration.setAttribute("org.eclipse.debug.core.capture_output", null);
        configuration.setAttribute("process_factory_id", "org.eclipse.statet.nico.LogRuntimeProcessFactory");
        configuration.setAttribute("org.eclipse.statet.nico/io/ControlSequences.AnsiEsc.process", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        if (this.ansiEscSeqButton != null) {
            this.ansiEscSeqButton.setSelection(this.readAttribute(configuration, "org.eclipse.statet.nico/io/ControlSequences.AnsiEsc.process", true));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("org.eclipse.debug.core.capture_output", null);
        configuration.setAttribute("process_factory_id", "org.eclipse.statet.nico.LogRuntimeProcessFactory");
        if (this.ansiEscSeqButton != null) {
            configuration.setAttribute("org.eclipse.statet.nico/io/ControlSequences.AnsiEsc.process", this.ansiEscSeqButton.getSelection());
        }
    }

    private static @Nullable Button findButton(Composite composite, String text) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Button button;
            Control control = controlArray[n2];
            if (control instanceof Button) {
                Button button2 = (Button)control;
                if (button2.getText().equals(text)) {
                    return button2;
                }
            } else if (control instanceof Composite && (button = CommonTabForConsole.findButton((Composite)control, text)) != null) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    private static @Nullable Group findGroup(Composite composite, String text) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Group group;
                if (control instanceof Group && (group = (Group)control).getText().equals(text)) {
                    return group;
                }
                Group group2 = CommonTabForConsole.findGroup((Composite)control, text);
                if (group2 != null) {
                    return group2;
                }
            }
            ++n2;
        }
        return null;
    }
}

