/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceAccessWrapper;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class AbstractProjectNature
extends PreferenceAccessWrapper
implements IProjectNature {
    private IProject project;
    private boolean configured;

    public void setProject(IProject project) {
        this.configured = true;
        this.project = project;
        super.setPreferenceContexts(this.createPrefContexts());
    }

    public void setPreferenceContexts(ImList<IScopeContext> contexts) {
        throw new UnsupportedOperationException();
    }

    public final IProject getProject() {
        return this.project;
    }

    public void configure() throws CoreException {
        this.addBuilders();
    }

    public void deconfigure() throws CoreException {
        this.configured = false;
        this.dispose();
        this.removeBuilders();
    }

    protected void addBuilders() throws CoreException {
    }

    protected void removeBuilders() throws CoreException {
    }

    private ImList<IScopeContext> createPrefContexts() {
        return ImCollections.newList((Object[])new IScopeContext[]{new ProjectScope(this.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
    }

    public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        ImList contexts = this.getPreferenceContexts();
        int i = 0;
        while (i < contexts.size() - 1) {
            IEclipsePreferences node = ((IScopeContext)contexts.get(i)).getNode(nodeQualifier);
            if (node != null) {
                node.addPreferenceChangeListener(listener);
            }
            ++i;
        }
    }

    public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        ImList contexts = this.getPreferenceContexts();
        int i = 0;
        while (i < contexts.size() - 1) {
            IEclipsePreferences node = ((IScopeContext)contexts.get(i)).getNode(nodeQualifier);
            if (node != null) {
                node.addPreferenceChangeListener(listener);
            }
            ++i;
        }
    }

    public final IScopeContext getProjectContext() {
        return (IScopeContext)this.getPreferenceContexts().getFirst();
    }

    protected final <T> T getProjectValue(Preference<T> key) {
        return (T)PreferenceUtils.getPrefValue((IScopeContext)((IScopeContext)this.getPreferenceContexts().getFirst()), key);
    }

    public int hashCode() {
        return this.getProject().hashCode() + 1;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.getProject().equals((Object)((AbstractProjectNature)((Object)obj)).getProject());
    }
}

