/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer.events;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.events.VisualChangeEvent;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class CellVisualChangeEvent
implements VisualChangeEvent {
    protected final Layer layer;
    protected final LPoint position;

    public CellVisualChangeEvent(Layer layer, LPoint position) {
        this.layer = layer;
        this.position = position;
    }

    public CellVisualChangeEvent(Layer layer, long columnPosition, long rowPosition) {
        this(layer, new LPoint(columnPosition, rowPosition));
    }

    @Override
    public @Nullable CellVisualChangeEvent toLayer(Layer targetLayer) {
        if (targetLayer == this.layer) {
            return this;
        }
        LayerDim hTargetDim = targetLayer.getDim(Orientation.HORIZONTAL);
        LayerDim vTargetDim = targetLayer.getDim(Orientation.VERTICAL);
        long hPosition = hTargetDim.underlyingToLocalPosition(this.layer.getDim(Orientation.HORIZONTAL), this.position.x);
        long vPosition = vTargetDim.underlyingToLocalPosition(this.layer.getDim(Orientation.VERTICAL), this.position.y);
        return hPosition >= 0L && hPosition < hTargetDim.getPositionCount() && vPosition >= 0L && vPosition < vTargetDim.getPositionCount() ? this.toLayer(targetLayer, hPosition, vPosition) : null;
    }

    protected @Nullable CellVisualChangeEvent toLayer(Layer targetLayer, long columnPosition, long rowPosition) {
        return new CellVisualChangeEvent(targetLayer, columnPosition, rowPosition);
    }

    @Override
    public final Layer getLayer() {
        return this.layer;
    }

    public LPoint getPosition() {
        return this.position;
    }

    public long getColumnPosition() {
        return this.position.x;
    }

    public long getRowPosition() {
        return this.position.y;
    }

    public ImList<LRectangle> getChangedPositionRectangles() {
        return ImCollections.newList((Object)new LRectangle(this.position.x, this.position.y, 1L, 1L));
    }
}

