/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.RegistryStyle;
import org.eclipse.statet.ecommons.waltable.painter.cell.TextPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class BlendedBackgroundPainter
extends TextPainter {
    private final RGB gridBackgroundColour;

    public BlendedBackgroundPainter(RGB gridBackgroundColour) {
        this.gridBackgroundColour = gridBackgroundColour;
    }

    @Override
    protected Color getBackgroundColour(LayerCell cell, ConfigRegistry configRegistry) {
        return BlendedBackgroundPainter.blendBackgroundColour(cell, configRegistry, this.gridBackgroundColour);
    }

    public static Color blendBackgroundColour(LayerCell cell, ConfigRegistry configRegistry, RGB baseColor) {
        List<Color> colours = CellStyleUtil.getAllBackgroundColors(cell, configRegistry, DisplayMode.NORMAL);
        if (cell.getDisplayMode().equals((Object)DisplayMode.SELECTED)) {
            RegistryStyle cellStyle = new RegistryStyle(configRegistry, CellConfigAttributes.CELL_STYLE, DisplayMode.SELECTED, cell.getLabels().getLabels());
            colours.add(cellStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR));
        }
        if (colours.size() == 0) {
            return null;
        }
        if (colours.size() == 1) {
            return colours.get(0);
        }
        RGB rgb = colours.get(0).getRGB();
        int i = 1;
        while (i < colours.size()) {
            if (rgb.equals((Object)baseColor)) {
                rgb = colours.get(i).getRGB();
            } else if (!colours.get(i).getRGB().equals((Object)baseColor)) {
                rgb = GUIHelper.blend(rgb, colours.get(i).getRGB());
            }
            ++i;
        }
        return new Color(rgb);
    }
}

