/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.Issue;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.impl.BasicIssueRequestor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueEditorAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueMarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

@NonNullByDefault
public class SourceAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final IssueTypeSet issueTypeSet;
    private final AtomicInteger reportingCounter = new AtomicInteger();
    private final List<SourceIssueEditorAnnotation> editorAnnotations = new ArrayList<SourceIssueEditorAnnotation>();
    private final PositionMap<SourceIssueMarkerAnnotation<?>> markerAnnotations = new PositionMap();
    private @Nullable ImSet<// Could not load outer class - annotation placement on inner may be incorrect
    IssueTypeSet.IssueCategory<?>> reportedConfig;
    private List<SourceIssueMarkerAnnotation<?>> overlaidMarkerAnnotations = new ArrayList();

    public SourceAnnotationModel(IResource resource, IssueTypeSet issueTypeSet) {
        super(resource);
        this.issueTypeSet = issueTypeSet;
    }

    protected IssueTypeSet getIssueTypeSet() {
        return this.issueTypeSet;
    }

    protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
        return true;
    }

    protected @Nullable MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        String annotationType;
        IssueTypeSet.IssueCategory issueCategory;
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if (markerType != null && (issueCategory = this.issueTypeSet.getCategory(Ltk.PERSISTENCE_CONTEXT, markerType = markerType.intern())) != null && (annotationType = issueCategory.mapType(Ltk.PERSISTENCE_CONTEXT, Ltk.EDITOR_CONTEXT, markerType)) != null) {
            return new SourceIssueMarkerAnnotation(issueCategory, annotationType, marker);
        }
        return super.createMarkerAnnotation(marker);
    }

    public final IssueRequestor createIssueRequestor() {
        this.reportingCounter.incrementAndGet();
        return this.doCreateIssueRequestor();
    }

    protected IssueRequestor doCreateIssueRequestor() {
        return new SourceAnnotationIssueRequestor(this.getIssueTypeSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIssues(ImList<BasicIssueRequestor.ProblemBatch> problemBatches) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.reportingCounter.decrementAndGet() != 0) {
                return;
            }
            ImSet<IssueTypeSet.IssueCategory<?>> prevConfig = this.reportedConfig;
            @NonNull Object[] enabledCagetories = new IssueTypeSet.IssueCategory[problemBatches.size()];
            int numEnabled = 0;
            for (BasicIssueRequestor.ProblemBatch problemBatch : problemBatches) {
                IssueTypeSet.ProblemCategory issueCategory = (IssueTypeSet.ProblemCategory)problemBatch.getCategory();
                if (problemBatch.isEnabled()) {
                    enabledCagetories[numEnabled++] = issueCategory;
                    if (prevConfig == null || prevConfig.contains(issueCategory)) continue;
                    this.resetMarkerAnnotationsControl((IssueTypeSet.IssueCategory<?>)issueCategory, true);
                    continue;
                }
                if (prevConfig == null || !prevConfig.contains(issueCategory)) continue;
                this.resetMarkerAnnotationsControl((IssueTypeSet.IssueCategory<?>)issueCategory, false);
            }
            this.reportedConfig = ImCollections.newIdentitySet((Object[])enabledCagetories, (int)0, (int)numEnabled);
            List<SourceIssueMarkerAnnotation<SourceIssueMarkerAnnotation<?>>> prevControlledAnnotations = this.overlaidMarkerAnnotations;
            this.overlaidMarkerAnnotations = new ArrayList();
            if (this.editorAnnotations.size() > 0) {
                this.removeAnnotations(this.editorAnnotations, false, true);
                this.editorAnnotations.clear();
            }
            for (BasicIssueRequestor.ProblemBatch problemBatch : problemBatches) {
                IssueTypeSet.ProblemTypes problemTypes = (IssueTypeSet.ProblemTypes)ObjectUtils.nonNullAssert((Object)((IssueTypeSet.ProblemCategory)problemBatch.getCategory()).getTypes(Ltk.EDITOR_CONTEXT));
                if (!problemBatch.isEnabled()) continue;
                for (Problem problem : problemBatch.getAcceptedIssues()) {
                    Position position = this.createPosition((Issue)problem);
                    if (position == null) continue;
                    try {
                        SourceIssueEditorAnnotation annotation = new SourceIssueEditorAnnotation((IssueTypeSet.IssueCategory<Problem>)problemBatch.getCategory(), problemTypes.getType(problem.getSeverity()), problem);
                        this.installMarkerAnnotationOverlays(position, annotation);
                        this.addAnnotation(annotation, position, false);
                        this.editorAnnotations.add(annotation);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (prevControlledAnnotations != null && !prevControlledAnnotations.isEmpty()) {
                prevControlledAnnotations.removeAll(this.overlaidMarkerAnnotations);
                for (BasicIssueRequestor.ProblemBatch problemBatch : problemBatches) {
                    if (!problemBatch.isEnabled()) continue;
                    this.removeMarkerAnnotationOverlays(prevControlledAnnotations, problemBatch.getCategory());
                }
            }
        }
        this.fireModelChanged();
    }

    protected @Nullable Position createPosition(Issue issue) {
        int start = issue.getSourceStartOffset();
        int end = issue.getSourceEndOffset();
        if (start == Integer.MIN_VALUE) {
            return new Position(0);
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            return null;
        }
        return new Position(start, end - start);
    }

    private void installMarkerAnnotationOverlays(Position position, SourceIssueEditorAnnotation problemAnnotation) {
        ImList<SourceIssueMarkerAnnotation<?>> annotations = this.markerAnnotations.get(position);
        if (annotations != null) {
            IssueTypeSet.IssueCategory<Problem> issueCategory = problemAnnotation.getIssueCategory();
            for (SourceIssueMarkerAnnotation markerAnnotation : annotations) {
                if (markerAnnotation.getIssueCategory() != issueCategory) continue;
                markerAnnotation.setOverlay(problemAnnotation);
                this.overlaidMarkerAnnotations.add(markerAnnotation);
            }
        }
    }

    private void removeMarkerAnnotationOverlays(List<SourceIssueMarkerAnnotation<?>> annotations, IssueTypeSet.IssueCategory<?> issueCategory) {
        for (SourceIssueMarkerAnnotation<?> markerAnnotation : annotations) {
            if (markerAnnotation.getIssueCategory() != issueCategory) continue;
            markerAnnotation.setOverlay(null);
        }
    }

    private void resetMarkerAnnotationsControl(IssueTypeSet.IssueCategory<?> issueCategory, boolean isControlled) {
        AnnotationModelEvent modelEvent = this.getAnnotationModelEvent();
        if (isControlled) {
            for (PositionMap.Entry<SourceIssueMarkerAnnotation<?>> entry : this.markerAnnotations) {
                for (SourceIssueMarkerAnnotation markerAnnotation : entry.annotations) {
                    if (markerAnnotation.getIssueCategory() != issueCategory || markerAnnotation.isControlled()) continue;
                    markerAnnotation.setOverlay(null);
                    modelEvent.annotationChanged((Annotation)markerAnnotation);
                }
            }
        } else {
            for (PositionMap.Entry<SourceIssueMarkerAnnotation<?>> entry : this.markerAnnotations) {
                for (SourceIssueMarkerAnnotation markerAnnotation : entry.annotations) {
                    if (markerAnnotation.getIssueCategory() != issueCategory || !markerAnnotation.isControlled()) continue;
                    markerAnnotation.disableOverlay();
                    modelEvent.annotationChanged((Annotation)markerAnnotation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        if (annotation instanceof SourceIssueMarkerAnnotation) {
            SourceIssueMarkerAnnotation markerAnnotation = (SourceIssueMarkerAnnotation)annotation;
            Object object = this.getLockObject();
            synchronized (object) {
                ImSet<IssueTypeSet.IssueCategory<?>> config = this.reportedConfig;
                if (config != null && config.contains(markerAnnotation.getIssueCategory())) {
                    markerAnnotation.setOverlay(null);
                    this.overlaidMarkerAnnotations.add(markerAnnotation);
                }
                this.markerAnnotations.add(position, markerAnnotation);
            }
        }
        super.addAnnotation(annotation, position, fireModelChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        SourceIssueMarkerAnnotation markerAnnotation;
        Position position;
        if (annotation instanceof SourceIssueMarkerAnnotation && (position = this.getPosition((Annotation)(markerAnnotation = (SourceIssueMarkerAnnotation)annotation))) != null) {
            Object object = this.getLockObject();
            synchronized (object) {
                if (markerAnnotation.isControlled()) {
                    markerAnnotation.disableOverlay();
                }
                this.markerAnnotations.remove(position, markerAnnotation);
            }
        }
        super.removeAnnotation(annotation, fireModelChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllAnnotations(boolean fireModelChanged) {
        super.removeAllAnnotations(fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            this.markerAnnotations.clear();
        }
    }

    private static class PositionMap<V>
    implements Iterable<Entry<V>> {
        private final List<Entry<V>> list = new ArrayList<Entry<V>>();
        private int anchor = 0;

        private int indexOf(Position position) {
            int length = this.list.size();
            int i = 0;
            while (i < length) {
                Entry<V> entry = this.list.get(i);
                if (entry.position.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public @Nullable ImList<V> get(Position position) {
            Entry<V> entry;
            int anchor = this.anchor;
            int length = this.list.size();
            if (anchor > length) {
                this.anchor = anchor = 0;
            }
            int i = anchor;
            while (i < length) {
                entry = this.list.get(i);
                if (entry.position.equals((Object)position)) {
                    this.anchor = i;
                    return entry.annotations;
                }
                ++i;
            }
            i = 0;
            while (i < anchor) {
                entry = this.list.get(i);
                if (entry.position.equals((Object)position)) {
                    this.anchor = i;
                    return entry.annotations;
                }
                ++i;
            }
            return null;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this.list.iterator();
        }

        public void add(Position position, V value) {
            int index = this.indexOf(position);
            if (index >= 0) {
                Entry<V> entry = this.list.get(index);
                entry.annotations = ImCollections.addElement(entry.annotations, value);
            } else {
                this.list.add(new Entry<V>(position, value));
            }
        }

        public void remove(Position position, Object value) {
            int index = this.indexOf(position);
            if (index >= 0) {
                Entry<V> entry = this.list.get(index);
                entry.annotations = ImCollections.removeElement(entry.annotations, (Object)value);
                if (entry.annotations.isEmpty()) {
                    this.list.remove(index);
                    if (this.anchor > index) {
                        --this.anchor;
                    }
                }
            }
        }

        public void clear() {
            this.list.clear();
            this.anchor = 0;
        }

        static class Entry<V> {
            final Position position;
            ImList<V> annotations;

            public Entry(Position position, V value) {
                this.position = position;
                this.annotations = ImCollections.newList(value);
            }
        }
    }

    protected class SourceAnnotationIssueRequestor
    extends BasicIssueRequestor {
        public SourceAnnotationIssueRequestor(IssueTypeSet issueTypeSet) {
            super(issueTypeSet, Ltk.EDITOR_CONTEXT);
        }

        protected boolean shouldAccept(IssueTypeSet.ProblemCategory category) {
            return SourceAnnotationModel.this.isHandlingTemporaryProblems(category);
        }

        protected boolean shouldAccept(IssueTypeSet.TaskCategory category) {
            return false;
        }

        protected void reportIssues(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable BasicIssueRequestor.TaskBatch taskBatch, ImList<BasicIssueRequestor.ProblemBatch> problemBatches) throws CoreException {
            SourceAnnotationModel.this.reportIssues(problemBatches);
        }
    }
}

