/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg.ast;

import java.util.ArrayList;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.Dummy;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.Name;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.RPkgSpecAstNode;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecAddition;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecItem;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecList;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.rj.renv.core.RNumVersionConstraint;

@NonNullByDefault
public class RPkgSpecValueParser {
    private TextParserInput parseInput;
    private final ArrayList<RPkgSpecAstNode> children = new ArrayList(32);
    public final IntList sepOffsets = new IntArrayList(32);

    protected void initInput(TextParserInput input, @Nullable AstNode parent) {
        this.parseInput = (TextParserInput)ObjectUtils.nonNullAssert((Object)input);
    }

    protected void clearInput() {
        this.parseInput = null;
        this.children.clear();
        this.sepOffsets.clear();
    }

    protected void clearData() {
    }

    protected void handleParseError(Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.dsl.core", String.format("An error occured while parsing R Pkg Spec source code. Input:\n%1$s", this.parseInput.toString()), (Throwable)e));
        this.clearData();
    }

    private void initTask() {
        this.clearData();
    }

    public @Nullable SpecList parseBundleSpecList(TextParserInput input, AstNode parent, boolean expand) {
        this.initInput(input, parent);
        try {
            this.initTask();
            SpecList node = new SpecList(parent, input.getStartIndex());
            this.readSpecList(node);
            if (!this.children.isEmpty()) {
                node.setChildren((ImIdentityList<RPkgSpecAstNode>)ImCollections.toIdentityList(this.children), ImCollections.toIntList((IntList)this.sepOffsets));
            } else {
                node.setChildren((ImIdentityList<RPkgSpecAstNode>)ImCollections.emptyIdentityList(), ImCollections.emptyIntList());
            }
            if (expand) {
                node.setStartEndOffset(input.getStartIndex(), input.getStopIndex());
            }
            SpecList specList = node;
            return specList;
        }
        catch (Exception e) {
            this.handleParseError(e);
            return null;
        }
        finally {
            this.clearInput();
        }
    }

    private void readSpecList(SpecList list) {
        TextParserInput in = this.parseInput;
        block8: while (true) {
            int start;
            this.skipWhitespace(in);
            int n = this.nSpecName(in);
            if (n > 0) {
                start = in.getIndex();
                SpecItem specItem = new SpecItem(list, start, start + in.getLengthInSource(n));
                this.children.add(specItem);
                specItem.setNameChild(new Name(specItem, start, specItem.getEndOffset(), in.getString(0, n)));
                in.consume(n);
                this.skipWhitespace(in);
                if (in.get(0) == 40) {
                    this.readConstraint(specItem, in);
                }
                switch (in.get(0)) {
                    case -1: {
                        break block8;
                    }
                    case 44: {
                        this.sepOffsets.add(in.getIndex());
                        in.consume(1);
                        break;
                    }
                    default: {
                        this.sepOffsets.add(Integer.MIN_VALUE);
                        break;
                    }
                }
                continue;
            }
            n = this.nListSep(in);
            if (n > 0) {
                start = in.getIndex();
                this.children.add(new Dummy(4196905, list, start, start + in.getLengthInSource(n)));
                in.consume(n);
            }
            switch (in.get(0)) {
                case -1: {
                    break block8;
                }
                case 44: {
                    if (n == 0) {
                        start = !this.sepOffsets.isEmpty() ? this.sepOffsets.getLast() + 1 : 0;
                        this.children.add(new Dummy(4196905, list, start, start));
                    }
                    this.sepOffsets.add(in.getIndex());
                    in.consume(1);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
    }

    private int nSpecName(TextParserInput in) {
        int n = 0;
        block4: while (true) {
            int next = in.get(n++);
            switch (next) {
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block4;
                }
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    return n - 1;
                }
            }
            if (!Character.isLetterOrDigit(next)) break;
        }
        return n - 1;
    }

    private int nListSep(TextParserInput in) {
        int n = 0;
        while (true) {
            int next = in.get(n++);
            switch (next) {
                case -1: 
                case 44: {
                    return n - 1;
                }
            }
        }
    }

    private void readConstraint(SpecItem specItem, TextParserInput in) {
        int n = 1;
        block8: while (true) {
            switch (in.get(n)) {
                case 9: 
                case 10: 
                case 32: {
                    ++n;
                    continue block8;
                }
            }
            break;
        }
        int textStart = n;
        int textEnd = n;
        block9: while (true) {
            switch (in.get(n++)) {
                case -1: 
                case 44: {
                    int start = in.getIndex();
                    specItem.setConstraintChild(new SpecAddition(4196897, specItem, start, start + in.getLengthInSource(textEnd)));
                    in.consume(n - 1);
                    return;
                }
                case 41: {
                    int start = in.getIndex();
                    specItem.setConstraintChild(this.createBundleSpecAddition(specItem, start, start + in.getLengthInSource(n), in.getString(textStart, textEnd)));
                    in.consume(n);
                    this.skipWhitespace(in);
                    return;
                }
                case 9: 
                case 10: 
                case 32: {
                    continue block9;
                }
            }
            textEnd = n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SpecAddition createBundleSpecAddition(SpecItem parent, int startOffset, int endOffset, String text) {
        int statusCode = 0;
        if (text.isEmpty()) return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
        switch (text.charAt(0)) {
            case '!': 
            case '<': 
            case '=': 
            case '>': {
                try {
                    RNumVersionConstraint versionConstraint = RNumVersionConstraint.create((String)text.replace('\n', ' '));
                    if (versionConstraint.getOperator() < 0) {
                        statusCode = 4196899;
                        return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
                    }
                    if (versionConstraint.getVersion().isValid()) return new SpecAddition(0, parent, startOffset, endOffset, text, versionConstraint);
                    statusCode = 4196901;
                    return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
                }
                catch (Exception e) {
                    statusCode = 4196896;
                }
                return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                statusCode = 4196899;
                return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
            }
        }
        return new SpecAddition(statusCode, parent, startOffset, endOffset, text, null);
    }

    private void skipWhitespace(TextParserInput in) {
        int n = 0;
        block3: while (true) {
            switch (in.get(n++)) {
                case 9: 
                case 10: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        if (n > 1) {
            in.consume(n - 1);
        }
    }
}

