/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Builder;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.model.RFunctionSpec;

@NonNullByDefault
public final class RFunctionSpecBuilder
implements Builder<RFunctionSpec> {
    private final List<RFunctionSpec.Parameter> parameters = new ArrayList<RFunctionSpec.Parameter>();
    private ImList<? extends RFunctionSpec.ReturnValue> returns = ImCollections.emptyList();

    public RFunctionSpecBuilder addParam(@Nullable String name, int type, @Nullable String className) {
        this.parameters.add(new RFunctionSpec.Parameter(this.parameters.size(), name, type, className));
        return this;
    }

    public RFunctionSpecBuilder addParam(@Nullable String name, int type) {
        this.parameters.add(new RFunctionSpec.Parameter(this.parameters.size(), name, type, null));
        return this;
    }

    public RFunctionSpecBuilder addParam(@Nullable String name) {
        this.parameters.add(new RFunctionSpec.Parameter(this.parameters.size(), name, 0, null));
        return this;
    }

    public RFunctionSpecBuilder addParams(String ... name) {
        int i = 0;
        while (i < name.length) {
            this.parameters.add(new RFunctionSpec.Parameter(this.parameters.size(), name[i], 0, null));
            ++i;
        }
        return this;
    }

    public RFunctionSpecBuilder returns(ImList<? extends RFunctionSpec.ReturnValue> returnTypes) {
        this.returns = (ImList)ObjectUtils.nonNullAssert(returnTypes);
        return this;
    }

    public RFunctionSpecBuilder returns(int type, @Nullable String className) {
        this.returns = ImCollections.newList((Object)new RFunctionSpec.ReturnValue(type, className));
        return this;
    }

    public RFunctionSpec build() {
        return new RFunctionSpec(this.parameters.toArray(new RFunctionSpec.Parameter[this.parameters.size()]), this.returns);
    }
}

