/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class ControlEnableStates {
    private final ImIdentityList<Control> exceptions;
    private final ImList<State> states;

    public static ControlEnableStates disable(Collection<Control> controls, Collection<Control> exceptions) {
        return new ControlEnableStates((ImList<Control>)ImCollections.toList(controls), (ImIdentityList<Control>)ImCollections.toIdentityList(exceptions), false);
    }

    public static ControlEnableStates disable(Collection<Control> controls) {
        return new ControlEnableStates((ImList<Control>)ImCollections.toList(controls), (ImIdentityList<Control>)ImCollections.emptyIdentityList(), false);
    }

    public static ControlEnableStates disable(Control control, Collection<Control> exceptions) {
        return new ControlEnableStates((ImList<Control>)ImCollections.newList((Object)control), (ImIdentityList<Control>)ImCollections.toIdentityList(exceptions), false);
    }

    public static ControlEnableStates disable(Control control) {
        return new ControlEnableStates((ImList<Control>)ImCollections.newList((Object)control), (ImIdentityList<Control>)ImCollections.emptyIdentityList(), false);
    }

    public static ControlEnableStates enable(Collection<Control> controls, Collection<Control> exceptions) {
        return new ControlEnableStates((ImList<Control>)ImCollections.toList(controls), (ImIdentityList<Control>)ImCollections.toIdentityList(exceptions), true);
    }

    public static ControlEnableStates enable(Collection<Control> controls) {
        return new ControlEnableStates((ImList<Control>)ImCollections.toList(controls), (ImIdentityList<Control>)ImCollections.emptyIdentityList(), true);
    }

    public static ControlEnableStates enable(Control control, Collection<Control> exceptions) {
        return new ControlEnableStates((ImList<Control>)ImCollections.newList((Object)control), (ImIdentityList<Control>)ImCollections.toIdentityList(exceptions), true);
    }

    public static ControlEnableStates enable(Control control) {
        return new ControlEnableStates((ImList<Control>)ImCollections.newList((Object)control), (ImIdentityList<Control>)ImCollections.emptyIdentityList(), true);
    }

    private ControlEnableStates(ImList<Control> controls, ImIdentityList<Control> exceptions, boolean enabled) {
        this.exceptions = exceptions;
        ArrayList<State> states = new ArrayList<State>();
        this.init(controls, enabled, states);
        this.states = ImCollections.toList(states);
    }

    private void init(ImList<? extends Control> controls, boolean enabled, List<State> states) {
        for (Control control : controls) {
            if (this.exceptions.contains((Object)control)) continue;
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                this.init((ImList<? extends Control>)ImCollections.newList((Object[])composite.getChildren()), enabled, states);
            }
            states.add(new State(control, control.getEnabled()));
            control.setEnabled(enabled);
        }
    }

    private @Nullable State getState(Control control) {
        for (State state : this.states) {
            if (state.control != control) continue;
            return state;
        }
        return null;
    }

    public void updateState(ImCollection<? extends Control> controls, boolean recursively, boolean enabled) {
        for (Control control : controls) {
            State state;
            if (this.exceptions.contains((Object)control) || (state = this.getState(control)) == null) continue;
            if (recursively && control instanceof Composite) {
                Composite composite = (Composite)control;
                this.updateState((ImCollection<? extends Control>)ImCollections.newList((Object[])composite.getChildren()), recursively, enabled);
            }
            state.enabled = enabled;
        }
    }

    public void updateState(Control control, boolean recursively, boolean enabled) {
        this.updateState((ImCollection<? extends Control>)ImCollections.newList((Object)control), recursively, enabled);
    }

    public void restore() {
        for (State state : this.states) {
            if (state.control.isDisposed()) continue;
            state.control.setEnabled(state.enabled);
        }
    }

    private static class State {
        protected final Control control;
        protected boolean enabled;

        public State(Control control, boolean enabled) {
            this.control = control;
            this.enabled = enabled;
        }
    }
}

