/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

@NonNullByDefault
public class UIAccess {
    public static final int SCHEDULE_TOLERANCE_MILLIS = 4;
    public static final int SCHEDULE_TOLERANCE_NANOS = 4000000;

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Display getDisplay(@Nullable Shell shell) {
        Display display = null;
        if (shell != null) {
            display = shell.getDisplay();
        }
        if (display == null) {
            display = UIAccess.getDisplay();
        }
        return display;
    }

    public static @Nullable IWorkbenchWindow getActiveWorkbenchWindow(boolean inUIThread) {
        if (inUIThread) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        Display display = UIAccess.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return (IWorkbenchWindow)display.syncCall(() -> PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static @Nullable IWorkbenchPage getActiveWorkbenchPage(boolean inUIThread) {
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static @Nullable IWorkbenchPart getActiveWorkbenchPart(boolean inUIThread) {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null && (activePage = window.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    public static @Nullable Shell getActiveWorkbenchShell(boolean inUIThread) {
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void checkedSyncExec(final CheckedRunnable runnable, Display display) throws CoreException {
        var catchRunnable = new Runnable(){
            private volatile @Nullable CoreException error;

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (CoreException e) {
                    this.error = e;
                }
            }
        };
        display.syncExec(catchRunnable);
        CoreException error = catchRunnable.error;
        if (error != null) {
            throw error;
        }
    }

    public static void checkedSyncExec(CheckedRunnable runnable) throws CoreException {
        UIAccess.checkedSyncExec(runnable, UIAccess.getDisplay());
    }

    @NonNullByDefault(value={NullDefaultLocation.PARAMETER})
    public static <T> T syncExecGet(Supplier<T> getter, Display display) {
        return (T)display.syncCall(getter::get);
    }

    @NonNullByDefault(value={NullDefaultLocation.PARAMETER})
    public static <T> T syncExecGet(Supplier<T> getter) {
        return UIAccess.syncExecGet(getter, UIAccess.getDisplay());
    }

    public static final boolean isOkToUse(@Nullable Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    public static final boolean isOkToUse(@Nullable Viewer viewer) {
        return viewer != null && UIAccess.isOkToUse(viewer.getControl());
    }

    private UIAccess() {
    }

    public static interface CheckedRunnable {
        public void run() throws CoreException;
    }
}

