/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.rhelp.core.RHelpCore;

@NonNullByDefault
public class RHelpUIResources {
    public static final Image R_PACKAGE_ICON = new Image("r-package");
    public static final Image RHELP_PAGE_ICON = new Image("r_help-page");
    public static final Image RHELP_PAGE_INTERNAL_ICON = new Image("r_help-page-internal");
    public static final Image RHELP_TOPIC_ICON = new Image("r_help-topic");
    public static final Image RHELP_TOPIC_INTERNAL_ICON = new Image("r_help-topic-internal");
    public static final Image ERROR_ICON = new Image("error");
    public static final Image FIX_INFO_ICON = new Image("fix_info");
    private static final ImList<Image> IMAGES = ImCollections.newList((Object[])new Image[]{R_PACKAGE_ICON, RHELP_PAGE_ICON, RHELP_PAGE_INTERNAL_ICON, RHELP_TOPIC_ICON, RHELP_TOPIC_INTERNAL_ICON, ERROR_ICON, FIX_INFO_ICON});

    public static ImList<Image> getImages() {
        return IMAGES;
    }

    public static void loadImagesContent(Map<String, byte[]> images) throws Exception {
        List bundles = CommonsRuntime.getEnvironment().resolveBundles((List)ImCollections.newList((Object)new BundleSpec("org.eclipse.statet.rhelp.core", RHelpCore.class)));
        for (Image image : RHelpUIResources.getImages()) {
            block1: for (PngFile file : image.getPngFiles()) {
                String resourcePathString = "images/" + file.getName();
                for (BundleEntry bundle : bundles) {
                    Path resourcePath = bundle.getResourcePath(resourcePathString);
                    if (resourcePath == null || !Files.isReadable(resourcePath)) continue;
                    byte[] bytes = Files.readAllBytes(resourcePath);
                    images.put(file.getName(), bytes);
                    continue block1;
                }
                throw new IOException(String.format("File note found '%1$s'.", resourcePathString));
            }
        }
    }

    public static class Image {
        private final String id;
        private final ImList<PngFile> pngFiles;

        public Image(String id) {
            this.id = id;
            this.pngFiles = ImCollections.newList((Object[])new PngFile[]{new PngFile(id, 1), new PngFile(id, 2)});
        }

        public String getId() {
            return this.id;
        }

        public ImList<PngFile> getPngFiles() {
            return this.pngFiles;
        }

        public String toString() {
            return this.id;
        }
    }

    public static class PngFile {
        private final String name;
        private final int scale;
        private final String htmlDescriptor;

        public PngFile(String id, int scale) {
            this.scale = scale;
            if (scale == 1) {
                this.name = id + ".png";
                this.htmlDescriptor = "";
            } else {
                this.name = id + "@" + scale + "x.png";
                this.htmlDescriptor = " " + scale + "x";
            }
        }

        public int getScale() {
            return this.scale;
        }

        public String getName() {
            return this.name;
        }

        public String getHtmlDescriptor() {
            return this.htmlDescriptor;
        }

        public String toString() {
            return this.name;
        }
    }
}

