/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.ltk.ui.TemplatesMessages;
import org.eclipse.statet.ltk.ui.templates.TemplateSelectionComposite;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateCategoryConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;

public class NewDocTemplateGenerateWizardPage
extends WizardPage {
    private final String categoryId;
    private final ITemplateCategoryConfiguration config;
    private TemplateSelectionComposite templateSelectComposite;

    public NewDocTemplateGenerateWizardPage(ITemplateCategoryConfiguration config, String categoryId) {
        super("CodeGen");
        this.config = config;
        this.categoryId = categoryId;
        this.setTitle(TemplatesMessages.NewDocWizardPage_title);
        this.setDescription(TemplatesMessages.NewDocWizardPage_description);
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        return this.config.getContextTypeRegistry();
    }

    public Template getTemplate() {
        if (this.templateSelectComposite != null) {
            return this.templateSelectComposite.getSelectedTemplate();
        }
        return this.config.getTemplates().findTemplate(this.categoryId, this.getDefaultTemplateName());
    }

    private String getDefaultTemplateName() {
        Preference<String> defaultPref = this.config.getDefaultPref();
        if (defaultPref == null) {
            return null;
        }
        return (String)EPreferences.getInstancePrefs().getPreferenceValue(defaultPref);
    }

    protected List<Template> getAvailableTemplates() {
        List<? extends TemplatePersistenceData> templateDatas = this.config.getTemplates().getTemplates(this.categoryId);
        ArrayList<Template> templates = new ArrayList<Template>(templateDatas.size());
        for (TemplatePersistenceData templatePersistenceData : templateDatas) {
            Template template = templatePersistenceData.getTemplate();
            if (!this.getCategoryId(template).equals(this.categoryId)) continue;
            templates.add(template);
        }
        return templates;
    }

    protected String getCategoryId(Template template) {
        String name = template.getName();
        int idx = name.indexOf(58);
        return idx > 0 ? name.substring(0, idx) : name;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        group.setText(TemplatesMessages.NewDocWizardPage_Template_group);
        this.templateSelectComposite = new TemplateSelectionComposite((Composite)group);
        this.templateSelectComposite.setLayoutData(new GridData(4, 4, true, true));
        this.templateSelectComposite.setConfigurator(this.config.createViewerConfiguator(null, null, this.templateSelectComposite.getPreview().getTemplateVariableProcessor(), null));
        this.templateSelectComposite.setInput(this.getAvailableTemplates(), true, this.getContextTypeRegistry());
        this.templateSelectComposite.setSelection(this.getDefaultTemplateName());
        this.setControl((Control)group);
    }
}

