/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.commonmark.core;

import java.util.List;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.CommonmarkConfig;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.AbstractMarkupConfig;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class BasicCommonmarkConfig<T extends BasicCommonmarkConfig<? super T>>
extends AbstractMarkupConfig<T>
implements CommonmarkConfig {
    public static final String HEADER_INTERRUPT_PARAGRAPH_DISABLED_PROP = "HeaderInterruptParagraphDisabled";
    private static final String HEADER_INTERRUPT_PARAGRAPH_DISABLED_KEY = "Paragraph+Header=Blank";
    public static final String BLOCKQUOTE_INTERRUPT_PARAGRAPH_DISABLED_PROP = "BlockquoteInterruptParagraphDisabled";
    private static final String BLOCKQUOTE_INTERRUPT_PARAGRAPH_DISABLED_KEY = "Paragraph+Blockquote=Blank";
    public static final String STRIKEOUT_DTILDE_ENABLED_PROP = "StrikeoutByDTildeEnabled";
    private static final String STRIKEOUT_DTILDE_KEY = "Strikeout=~~";
    public static final String SUPERSCRIPT_SCIRCUMFLEX_ENABLED_PROP = "SuperscriptBySCircumflexEnabled";
    private static final String SUPERSCRIPT_SCIRCUMFLEX_KEY = "Superscript=^";
    public static final String SUBSCRIPT_STILDE_ENABLED_PROP = "SubscriptBySTildeEnabled";
    private static final String SUBSCRIPT_STILDE_KEY = "Subscript=~";
    private boolean isHeaderInterruptParagraphDisabled;
    private boolean isBlockquoteInterruptParagraphDisabled;
    private boolean isStrikeoutDTildeEnabled;
    private boolean isSuperscriptSCircumflexEnabled;
    private boolean isSubscriptSTildeEnabled;

    protected String getConfigType() {
        return "Commonmark";
    }

    @Override
    public boolean isHeaderInterruptParagraphDisabled() {
        return this.isHeaderInterruptParagraphDisabled;
    }

    public void setHeaderInterruptParagraphDisabled(boolean enabled) {
        this.checkSeal();
        if (this.isHeaderInterruptParagraphDisabled != enabled) {
            this.isHeaderInterruptParagraphDisabled = enabled;
            this.afterChange(HEADER_INTERRUPT_PARAGRAPH_DISABLED_PROP);
        }
    }

    @Override
    public boolean isBlockquoteInterruptParagraphDisabled() {
        return this.isBlockquoteInterruptParagraphDisabled;
    }

    public void setBlockquoteInterruptParagraphDisabled(boolean enabled) {
        this.checkSeal();
        if (this.isBlockquoteInterruptParagraphDisabled != enabled) {
            this.isBlockquoteInterruptParagraphDisabled = enabled;
            this.afterChange(BLOCKQUOTE_INTERRUPT_PARAGRAPH_DISABLED_PROP);
        }
    }

    @Override
    public boolean isStrikeoutByDTildeEnabled() {
        return this.isStrikeoutDTildeEnabled;
    }

    public void setStrikeoutDTildeEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isStrikeoutDTildeEnabled != enabled) {
            this.isStrikeoutDTildeEnabled = enabled;
            this.afterChange(STRIKEOUT_DTILDE_ENABLED_PROP);
        }
    }

    @Override
    public boolean isSuperscriptBySCircumflexEnabled() {
        return this.isSuperscriptSCircumflexEnabled;
    }

    public void setSuperscriptSCircumflexEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isSuperscriptSCircumflexEnabled != enabled) {
            this.isSuperscriptSCircumflexEnabled = enabled;
            this.afterChange(SUPERSCRIPT_SCIRCUMFLEX_ENABLED_PROP);
        }
    }

    @Override
    public boolean isSubscriptBySTildeEnabled() {
        return this.isSubscriptSTildeEnabled;
    }

    public void setSubscriptSTildeEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isSubscriptSTildeEnabled != enabled) {
            this.isSubscriptSTildeEnabled = enabled;
            this.afterChange(SUBSCRIPT_STILDE_ENABLED_PROP);
        }
    }

    protected void createConfigString(StringBuilder sb) {
        super.createConfigString(sb);
        if (this.isHeaderInterruptParagraphDisabled()) {
            sb.append(HEADER_INTERRUPT_PARAGRAPH_DISABLED_KEY);
        }
        if (this.isBlockquoteInterruptParagraphDisabled()) {
            sb.append(BLOCKQUOTE_INTERRUPT_PARAGRAPH_DISABLED_KEY);
        }
        if (this.isStrikeoutByDTildeEnabled()) {
            sb.append(STRIKEOUT_DTILDE_KEY);
        }
        if (this.isSuperscriptBySCircumflexEnabled()) {
            sb.append(SUPERSCRIPT_SCIRCUMFLEX_KEY);
        }
        if (this.isSubscriptBySTildeEnabled()) {
            sb.append(SUBSCRIPT_STILDE_KEY);
        }
    }

    protected void load(String configType, List<String> s) {
        super.load(configType, s);
        this.setHeaderInterruptParagraphDisabled(s.contains(HEADER_INTERRUPT_PARAGRAPH_DISABLED_KEY));
        this.setBlockquoteInterruptParagraphDisabled(s.contains(BLOCKQUOTE_INTERRUPT_PARAGRAPH_DISABLED_KEY));
        this.setStrikeoutDTildeEnabled(s.contains(STRIKEOUT_DTILDE_KEY));
        this.setSuperscriptSCircumflexEnabled(s.contains(SUPERSCRIPT_SCIRCUMFLEX_KEY));
        this.setSubscriptSTildeEnabled(s.contains(SUBSCRIPT_STILDE_KEY));
    }

    public void load(T config) {
        super.load(config);
        this.setHeaderInterruptParagraphDisabled(((BasicCommonmarkConfig)config).isHeaderInterruptParagraphDisabled());
        this.setBlockquoteInterruptParagraphDisabled(((BasicCommonmarkConfig)config).isBlockquoteInterruptParagraphDisabled());
        this.setStrikeoutDTildeEnabled(((BasicCommonmarkConfig)config).isStrikeoutByDTildeEnabled());
        this.setSuperscriptSCircumflexEnabled(((BasicCommonmarkConfig)config).isSuperscriptBySCircumflexEnabled());
        this.setSubscriptSTildeEnabled(((BasicCommonmarkConfig)config).isSubscriptBySTildeEnabled());
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof BasicCommonmarkConfig)) break block3;
                BasicCommonmarkConfig other = (BasicCommonmarkConfig)obj;
                if (super.equals(obj) && this.isHeaderInterruptParagraphDisabled() == other.isHeaderInterruptParagraphDisabled() && this.isBlockquoteInterruptParagraphDisabled() == other.isBlockquoteInterruptParagraphDisabled() && this.isStrikeoutByDTildeEnabled() == other.isStrikeoutByDTildeEnabled() && this.isSuperscriptBySCircumflexEnabled() == other.isSuperscriptBySCircumflexEnabled() && this.isSubscriptBySTildeEnabled() == other.isSubscriptBySTildeEnabled()) break block2;
            }
            return false;
        }
        return true;
    }
}

