/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.OkStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.RunnableStatus;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolQueue;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;

@NonNullByDefault
public final class Queue
implements ToolQueue {
    public static final byte INIT_STATE = 1;
    public static final byte PROCESSING_STATE = 2;
    public static final byte IDLING_STATE = 3;
    public static final byte PAUSED_STATE = 5;
    public static final byte TERMINATED_STATE = 6;
    public static final int QUEUE_INFO = 1;
    public static final int STATE_REQUEST = 5;
    public static final int IF_ABSENT = 1;
    private static final Status ADDED_STATUS = new OkStatus("org.eclipse.statet.nico.core", "Added.");
    public static final Status ALREADY_PRESENT_STATUS = new InfoStatus("org.eclipse.statet.nico.core", "Already in queue.");
    static final int RUN_NONE = -2;
    static final int RUN_SUSPEND = -1;
    static final int RUN_CONTROL = 1;
    static final int RUN_HOT = 2;
    static final int RUN_OTHER = 3;
    static final int RUN_DEFAULT = 4;
    private final ArrayList<SubQueue> sectionStack = new ArrayList();
    private final SubQueue topLevelSection;
    private SubQueue currentSection;
    private @Nullable ImList<ToolRunnable> singleIOCache = null;
    private final Deque<ImList<ToolRunnable>> finishedExpected = new ArrayDeque<ImList<ToolRunnable>>();
    private final ArrayList<DebugEvent> eventList = new ArrayList(5);
    private final ToolProcess process;
    private boolean resetOnIdle = true;
    private final ArrayList<RankedItem> onIdleList = new ArrayList();
    private final LinkedList<ToolRunnable> currentIdleList = new LinkedList();
    private final ArrayDeque<ToolRunnable> hotList = new ArrayDeque();
    private byte state;
    private byte stateRequest = (byte)2;

    public static final boolean isStateChange(DebugEvent event) {
        return event.getKind() == 16 && event.getDetail() == 256;
    }

    public static final boolean isStateRequest(DebugEvent event) {
        return event.getKind() == 32 && event.getDetail() == 5;
    }

    private static final int toRequestState(int state) {
        return state == 3 ? 2 : state;
    }

    private static ToolRunnable checkRunnable(@Nullable ToolRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        return runnable;
    }

    private static ImList<ToolRunnable> checkRunnableList(@Nullable ToolRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        return ImCollections.newList((Object)runnable);
    }

    private static ImList<ToolRunnable> checkRunnableList(@Nullable List<ToolRunnable> runnables) {
        if (runnables == null) {
            throw new NullPointerException("runnables");
        }
        ImList finalRunnables = ImCollections.toList(runnables);
        int i = finalRunnables.indexOf(null);
        if (i >= 0) {
            throw new NullPointerException("runnable[" + i + "]");
        }
        return finalRunnables;
    }

    Queue(ToolProcess process) {
        this.process = process;
        this.topLevelSection = new TopLevelQueue();
        this.sectionStack.add(this.topLevelSection);
        this.currentSection = this.topLevelSection;
    }

    private final Status acceptSubmit(ToolStatus toolStatus) {
        if (toolStatus == ToolStatus.TERMINATED) {
            return new ErrorStatus("org.eclipse.statet.nico.core", -1, NLS.bind((String)Messages.ToolController_ToolTerminated_message, (Object)this.process.getLabel(0)), null);
        }
        return ADDED_STATUS;
    }

    private final Status acceptSubmit(ToolStatus toolStatus, SubQueue section) {
        if (toolStatus == ToolStatus.TERMINATED) {
            return new ErrorStatus("org.eclipse.statet.nico.core", -1, NLS.bind((String)Messages.ToolController_ToolTerminated_message, (Object)this.process.getLabel(0)), null);
        }
        if (section.isDispose()) {
            return new ErrorStatus("org.eclipse.statet.nico.core", -1, NLS.bind((String)Messages.ToolController_QueueSectionTerminated_message, (Object)this.process.getLabel(0)), null);
        }
        return ADDED_STATUS;
    }

    public synchronized void sendElements() {
        this.checkIOCache();
        ImList<ToolRunnable> runnables = this.internal_createCompleteList();
        DebugEvent event = new DebugEvent((Object)this, 32, 1);
        event.setData(runnables);
        this.eventList.add(event);
        this.internal_fireEvents();
    }

    public Section getTopLevelSection() {
        return this.topLevelSection;
    }

    public synchronized Section getCurrentSection() {
        return this.currentSection;
    }

    public synchronized int getCurrentSize() {
        if (this.singleIOCache != null) {
            return 1;
        }
        return this.currentSection.list.size();
    }

    public Status add(ToolRunnable runnable) {
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnable);
        return this.doAdd(checkedRunnables, null);
    }

    public Status add(List<ToolRunnable> runnables) {
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnables);
        return this.doAdd(checkedRunnables, null);
    }

    public Status add(ToolRunnable runnable, @Nullable Section section, int strategy) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        return this.doAdd(checkedRunnable, (SubQueue)section, strategy);
    }

    public Status add(List<ToolRunnable> runnables, @Nullable Section section) {
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnables);
        return this.doAdd(checkedRunnables, (SubQueue)section);
    }

    private synchronized Status doAdd(ImList<ToolRunnable> runnables, @Nullable SubQueue section) {
        ToolStatus toolStatus;
        Status status;
        if (section == null) {
            section = this.currentSection;
        }
        if ((status = this.acceptSubmit(toolStatus = this.process.getToolStatus(), section)).getSeverity() < 4) {
            if (toolStatus.isWaiting()) {
                this.internal_add(runnables, section, true);
                this.notifyAll();
            } else {
                this.internal_add(runnables, section, false);
            }
        }
        return status;
    }

    private synchronized Status doAdd(ToolRunnable runnable, @Nullable SubQueue section, int strategy) {
        ToolStatus toolStatus;
        Status status;
        if (section == null) {
            section = this.currentSection;
        }
        if ((status = this.acceptSubmit(toolStatus = this.process.getToolStatus(), section)).getSeverity() < 4) {
            if (strategy != 0) {
                int idx;
                this.checkIOCache();
                if ((strategy & 1) != 0 && (idx = section.list.indexOf(runnable)) >= 0) {
                    return new RunnableInfoStatus(0, ALREADY_PRESENT_STATUS.getMessage(), section.list.get(idx));
                }
            }
            if (toolStatus.isWaiting()) {
                this.internal_add((ImList<ToolRunnable>)ImCollections.newList((Object)runnable), section, true);
                this.notifyAll();
            } else {
                this.internal_add((ImList<ToolRunnable>)ImCollections.newList((Object)runnable), section, false);
            }
            return new RunnableOkStatus(ADDED_STATUS.getMessage(), runnable);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ToolRunnable runnable) {
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnable);
        Queue queue = this;
        synchronized (queue) {
            this.internal_remove(checkedRunnables);
            this.internal_fireEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<ToolRunnable> runnables) {
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnables);
        Queue queue = this;
        synchronized (queue) {
            this.internal_remove(checkedRunnables);
            this.internal_fireEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(ImList<ToolRunnable> runnables, Queue to) {
        ImList<ToolRunnable> finalRunnables;
        ImList<ToolRunnable> checkedRunnables = Queue.checkRunnableList(runnables);
        if (to == null) {
            throw new NullPointerException("to");
        }
        Queue queue = this;
        synchronized (queue) {
            finalRunnables = this.internal_moveFrom(checkedRunnables);
        }
        queue = to;
        synchronized (queue) {
            to.internal_moveTo(finalRunnables, to.currentSection);
            to.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAll(Queue to) {
        ImList finalRunnables;
        if (to == null) {
            throw new NullPointerException("to");
        }
        Queue queue = this;
        synchronized (queue) {
            this.checkIOCache();
            ArrayList<ToolRunnable> removed = new ArrayList<ToolRunnable>(this.internal_getCompleteSize());
            Iterator iter = this.topLevelSection.list.iterator();
            while (iter.hasNext()) {
                ToolRunnable runnable = (ToolRunnable)iter.next();
                if (!runnable.changed(289, (Tool)this.process)) continue;
                iter.remove();
                removed.add(runnable);
            }
            finalRunnables = ImCollections.toList(removed);
            this.addContentChangeEvent(new TaskDelta(289, -1, (ImList<ToolRunnable>)finalRunnables));
            this.internal_fireEvents();
        }
        queue = to;
        synchronized (queue) {
            to.internal_moveTo((ImList<ToolRunnable>)finalRunnables, to.topLevelSection);
            to.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status addOnIdle(SystemRunnable runnable, int rank) {
        ToolRunnable checkedRunnable = Queue.checkRunnable((ToolRunnable)runnable);
        Queue queue = this;
        synchronized (queue) {
            ToolStatus toolStatus = this.process.getToolStatus();
            Status status = this.acceptSubmit(toolStatus);
            if (status.getSeverity() < 4) {
                RankedItem item = new RankedItem(checkedRunnable, rank);
                int idx = this.onIdleList.indexOf(item);
                if (idx >= 0 && this.onIdleList.get((int)idx).rank != rank) {
                    this.onIdleList.remove(idx);
                    if (!this.resetOnIdle) {
                        this.currentIdleList.remove(item.runnable);
                    }
                    idx = -1;
                }
                if (idx < 0) {
                    idx = 0;
                    while (idx < this.onIdleList.size()) {
                        if (this.onIdleList.get((int)idx).rank > rank) break;
                        ++idx;
                    }
                    this.onIdleList.add(idx, item);
                    if (!this.resetOnIdle) {
                        if (idx == this.onIdleList.size() - 1) {
                            this.currentIdleList.add(item.runnable);
                        } else {
                            RankedItem next = this.onIdleList.get(idx + 1);
                            int nextIdx = this.currentIdleList.indexOf(next.runnable);
                            if (nextIdx >= 0) {
                                this.currentIdleList.add(nextIdx, item.runnable);
                            }
                        }
                    }
                }
                this.notifyAll();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnIdle(ToolRunnable runnable) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        Queue queue = this;
        synchronized (queue) {
            this.onIdleList.remove(new RankedItem(checkedRunnable, 0));
            this.currentIdleList.remove(runnable);
        }
    }

    public boolean isHotSupported() {
        return true;
    }

    public Status addHot(ToolRunnable runnable) {
        return this.addHot(runnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status addHot(ToolRunnable runnable, int strategy) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        Queue queue = this;
        synchronized (queue) {
            ToolStatus toolStatus = this.process.getToolStatus();
            Status status = this.acceptSubmit(toolStatus);
            if (status.getSeverity() < 4) {
                if ((strategy & 1) != 0 && this.hotList.contains(checkedRunnable)) {
                    return ALREADY_PRESENT_STATUS;
                }
                this.hotList.addLast(checkedRunnable);
                this.notifyAll();
                ToolController controller = this.process.getController();
                if (controller != null) {
                    controller.scheduleHotMode();
                }
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHot(ToolRunnable runnable) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        Queue queue = this;
        synchronized (queue) {
            if (this.hotList.removeFirstOccurrence(checkedRunnable)) {
                runnable.changed(288, (Tool)this.process);
            }
        }
    }

    private void internal_add(ImList<ToolRunnable> runnables, SubQueue section, boolean allowCache) {
        if (allowCache && this.singleIOCache == null && runnables.size() == 1 && section == this.currentSection && this.currentSection.list.isEmpty()) {
            this.singleIOCache = runnables;
            return;
        }
        this.checkIOCache();
        int idx = section.getAppendIdx();
        section.append(runnables);
        this.addContentChangeEvent(new TaskDelta(272, idx, runnables));
        this.internal_fireEvents();
    }

    private void internal_remove(ImList<ToolRunnable> runnables) {
        this.checkIOCache();
        ArrayList<ToolRunnable> removed = new ArrayList<ToolRunnable>(runnables.size());
        block0: for (ToolRunnable runnable : runnables) {
            int iSection = this.sectionStack.size() - 1;
            while (iSection >= 0) {
                SubQueue section = this.sectionStack.get(iSection);
                int idx = section.list.indexOf(runnable);
                if (idx >= 0) {
                    if (!runnable.changed(288, (Tool)this.process)) continue block0;
                    section.list.remove(idx);
                    removed.add(runnable);
                    continue block0;
                }
                --iSection;
            }
        }
        ImList finalRunnables = ImCollections.toList(removed);
        this.addContentChangeEvent(new TaskDelta(288, -1, (ImList<ToolRunnable>)finalRunnables));
        this.internal_fireEvents();
    }

    private ImList<ToolRunnable> internal_moveFrom(ImList<ToolRunnable> runnables) {
        this.checkIOCache();
        ArrayList<ToolRunnable> removed = new ArrayList<ToolRunnable>(runnables.size());
        block0: for (ToolRunnable runnable : runnables) {
            int iSection = this.sectionStack.size() - 1;
            while (iSection >= 0) {
                SubQueue section = this.sectionStack.get(iSection);
                int idx = section.list.indexOf(runnable);
                if (idx >= 0) {
                    if (!runnable.changed(289, (Tool)this.process)) continue block0;
                    section.list.remove(idx);
                    removed.add(runnable);
                    continue block0;
                }
                --iSection;
            }
        }
        ImList finalRunnables = ImCollections.toList(removed);
        this.addContentChangeEvent(new TaskDelta(289, -1, (ImList<ToolRunnable>)finalRunnables));
        this.internal_fireEvents();
        return finalRunnables;
    }

    private void internal_moveTo(ImList<ToolRunnable> runnables, SubQueue section) {
        this.checkIOCache();
        int idx = section.getAppendIdx();
        section.append(runnables);
        this.addContentChangeEvent(new TaskDelta(273, idx, runnables));
        this.internal_fireEvents();
    }

    Section internal_addInsert(ToolRunnable runnable) {
        assert (runnable != null);
        this.checkIOCache();
        InsertQueue section = new InsertQueue(runnable);
        this.sectionStack.add(section);
        this.currentSection.next = section;
        this.currentSection = section;
        this.addContentChangeEvent(new TaskDelta(272, 0, (ImList<ToolRunnable>)ImCollections.newList((Object)runnable)));
        this.internal_resetOnIdle();
        this.internal_fireEvents();
        return section;
    }

    void internal_removeInsert(Section section) {
        assert (section != null);
        this.checkIOCache();
        int sectionIdx = this.sectionStack.indexOf(section);
        if (sectionIdx < 0) {
            return;
        }
        if (sectionIdx == 0) {
            throw new IllegalArgumentException();
        }
        Object[] runnables = new ToolRunnable[this.internal_getSize(sectionIdx, this.sectionStack.size())];
        int i = 0;
        int iSection = this.sectionStack.size() - 1;
        while (iSection >= sectionIdx) {
            SubQueue removedSection = this.sectionStack.remove(iSection);
            i = removedSection.getAll((ToolRunnable[])runnables, i);
            removedSection.dispose();
            --iSection;
        }
        this.currentSection = this.sectionStack.getLast();
        this.currentSection.next = null;
        ImList finalRunnables = ImCollections.newList((Object[])runnables);
        for (ToolRunnable runnable : finalRunnables) {
            if (runnable.changed(288, (Tool)this.process)) continue;
            runnable.changed(290, (Tool)this.process);
        }
        this.addContentChangeEvent(new TaskDelta(288, -1, (ImList<ToolRunnable>)finalRunnables));
        this.internal_resetOnIdle();
        this.internal_fireEvents();
    }

    void internal_scheduleIdle(ToolRunnable runnable) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        this.currentIdleList.add(checkedRunnable);
    }

    void internal_removeIdle(ToolRunnable runnable) {
        ToolRunnable checkedRunnable = Queue.checkRunnable(runnable);
        this.currentIdleList.remove(checkedRunnable);
    }

    void internal_check() {
        this.checkIOCache();
        this.internal_fireEvents();
    }

    void internal_resetOnIdle() {
        this.resetOnIdle = true;
    }

    private void internal_resetIdleList() {
        this.resetOnIdle = false;
        this.currentIdleList.clear();
        int i = 0;
        while (i < this.onIdleList.size()) {
            this.currentIdleList.add(this.onIdleList.get((int)i).runnable);
            ++i;
        }
    }

    int internal_next() {
        ToolRunnable runnable;
        if (!this.hotList.isEmpty()) {
            return 2;
        }
        if (this.singleIOCache != null) {
            runnable = (ToolRunnable)this.singleIOCache.get(0);
        } else if (!this.currentSection.list.isEmpty()) {
            runnable = this.currentSection.list.peekFirst();
        } else {
            if (this.resetOnIdle) {
                this.internal_resetIdleList();
            }
            if (!this.currentIdleList.isEmpty()) {
                runnable = this.currentIdleList.peekFirst();
            } else {
                return -2;
            }
        }
        return runnable instanceof SystemRunnable ? 3 : 4;
    }

    ToolRunnable internal_poll() {
        ImList finalRunnable;
        if (this.singleIOCache != null) {
            finalRunnable = this.singleIOCache;
            int idx = this.currentSection.getAppendIdx();
            this.addContentChangeEvent(new TaskDelta(272, idx, (ImList<ToolRunnable>)finalRunnable));
            this.singleIOCache = null;
            this.internal_resetOnIdle();
        } else if (!this.currentSection.list.isEmpty()) {
            finalRunnable = ImCollections.newList((Object)this.currentSection.list.pollFirst());
            this.internal_resetOnIdle();
        } else {
            finalRunnable = ImCollections.newList((Object)this.currentIdleList.pollFirst());
        }
        this.addContentChangeEvent(new TaskDelta(320, -1, (ImList<ToolRunnable>)finalRunnable));
        this.internal_fireEvents();
        this.finishedExpected.push((ImList<ToolRunnable>)finalRunnable);
        return (ToolRunnable)finalRunnable.get(0);
    }

    boolean internal_nextHot() {
        return !this.hotList.isEmpty();
    }

    @Nullable ToolRunnable internal_pollHot() {
        return this.hotList.pollFirst();
    }

    void internal_onFinished(ToolRunnable runnable, int detail) {
        assert (runnable == this.finishedExpected.peek().get(0));
        this.addContentChangeEvent(new TaskDelta(detail, -1, this.finishedExpected.poll()));
    }

    private int internal_getCompleteSize() {
        int size = 0;
        int iSection = this.sectionStack.size() - 1;
        while (iSection >= 0) {
            size += this.sectionStack.get(iSection).getAllSize();
            --iSection;
        }
        return size;
    }

    private int internal_getSize(int startSection, int endSection) {
        int size = 0;
        int iSection = endSection - 1;
        while (iSection >= startSection) {
            size += this.sectionStack.get(iSection).getAllSize();
            --iSection;
        }
        return size;
    }

    private ImList<ToolRunnable> internal_createCompleteList() {
        Object[] runnables = new ToolRunnable[this.internal_getCompleteSize()];
        int i = 0;
        int iSection = this.sectionStack.size() - 1;
        while (iSection >= 0) {
            i = this.sectionStack.get(iSection).getAll((ToolRunnable[])runnables, i);
            --iSection;
        }
        return ImCollections.newList((Object[])runnables);
    }

    List<ToolRunnable> internal_getList() {
        this.internal_check();
        return this.internal_createCompleteList();
    }

    List<ToolRunnable> internal_getCurrentList() {
        this.internal_check();
        return this.currentSection.list;
    }

    public synchronized boolean isRequested(byte state) {
        return this.state == state || this.stateRequest == state;
    }

    public synchronized boolean pause() {
        if (this.state == 6) {
            return false;
        }
        byte oldState = this.stateRequest;
        if (oldState != 5) {
            this.stateRequest = (byte)5;
            this.addStateEvent(32, 5, new StateDelta(oldState, 5));
            this.internal_fireEvents();
            this.notifyAll();
        }
        return true;
    }

    public synchronized boolean resume() {
        if (this.state == 6) {
            return false;
        }
        byte oldState = this.stateRequest;
        if (oldState != 2) {
            this.stateRequest = (byte)2;
            this.addStateEvent(32, 5, new StateDelta(oldState, 2));
            this.internal_fireEvents();
            this.notifyAll();
        }
        return true;
    }

    void internal_onStatusChanged(ToolStatus newStatus) {
        byte oldState = this.state;
        switch (newStatus) {
            case STARTED_IDLING: 
            case STARTED_SUSPENDED: {
                this.state = (byte)3;
                break;
            }
            case STARTED_PAUSED: {
                this.state = (byte)5;
                break;
            }
            case TERMINATED: {
                this.state = (byte)6;
                break;
            }
            default: {
                this.state = (byte)2;
            }
        }
        this.addStateEvent(16, 256, new StateDelta(oldState, this.state));
        if (this.stateRequest == 5 && oldState == 5) {
            this.stateRequest = (byte)2;
            this.addStateEvent(32, 5, new StateDelta(5, 2));
        } else if (this.stateRequest == 6 && this.state == 6) {
            this.stateRequest = (byte)2;
            this.addStateEvent(32, 5, new StateDelta(6, 2));
        }
    }

    boolean internal_isPauseRequested() {
        return this.stateRequest == 5;
    }

    void internal_dispose() {
        ImList leftRunnable;
        this.checkIOCache();
        byte oldState = this.state;
        if (oldState != 6) {
            this.state = (byte)6;
            this.addStateEvent(16, 256, new StateDelta(oldState, 6));
        }
        Object[] runnables = new ToolRunnable[this.internal_getCompleteSize()];
        int i = 0;
        int iSection = this.sectionStack.size() - 1;
        while (iSection >= 1) {
            SubQueue removedSection = this.sectionStack.remove(iSection);
            i = removedSection.getAll((ToolRunnable[])runnables, i);
            removedSection.dispose();
            --iSection;
        }
        i = this.topLevelSection.getAll((ToolRunnable[])runnables, i);
        this.topLevelSection.dispose();
        this.currentSection = this.topLevelSection;
        this.currentSection.next = null;
        ImList finalRunnables = ImCollections.newList((Object[])runnables);
        for (ToolRunnable runnable : finalRunnables) {
            runnable.changed(290, (Tool)this.process);
        }
        this.addTerminateEvent(new TaskDelta(290, -1, (ImList<ToolRunnable>)finalRunnables));
        if (!this.hotList.isEmpty()) {
            leftRunnable = ImCollections.toList(this.hotList);
            this.hotList.clear();
            for (ToolRunnable runnable : leftRunnable) {
                runnable.changed(290, (Tool)this.process);
            }
        }
        if (!this.onIdleList.isEmpty()) {
            leftRunnable = ImCollections.toList(this.onIdleList);
            this.onIdleList.clear();
            for (RankedItem item : leftRunnable) {
                item.runnable.changed(290, (Tool)this.process);
            }
        }
        this.internal_fireEvents();
    }

    private void checkIOCache() {
        if (this.singleIOCache != null) {
            int idx = this.currentSection.getAppendIdx();
            this.currentSection.append((ToolRunnable)this.singleIOCache.get(0));
            this.addContentChangeEvent(new TaskDelta(272, idx, this.singleIOCache));
            this.singleIOCache = null;
        }
    }

    private void addContentChangeEvent(TaskDelta delta) {
        DebugEvent event = new DebugEvent((Object)this, 16, 512);
        event.setData((Object)delta);
        this.eventList.add(event);
    }

    private void addStateEvent(int kind, int detail, StateDelta delta) {
        DebugEvent event = new DebugEvent((Object)this, kind, detail);
        event.setData((Object)delta);
        this.eventList.add(event);
    }

    private void addTerminateEvent(TaskDelta delta) {
        DebugEvent event = new DebugEvent((Object)this, 8, 0);
        event.setData((Object)delta);
        this.eventList.add(event);
    }

    List<DebugEvent> internal_getEventList() {
        return this.eventList;
    }

    void internal_fireEvents() {
        if (this.eventList.isEmpty()) {
            return;
        }
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(this.eventList.toArray(new DebugEvent[this.eventList.size()]));
        }
        this.eventList.clear();
    }

    private static final class InsertQueue
    extends SubQueue {
        protected final ToolRunnable insertRunnable;

        public InsertQueue(ToolRunnable insertRunnable) {
            this.insertRunnable = insertRunnable;
        }

        @Override
        public int getAllSize() {
            return this.list.size() + 1;
        }

        @Override
        public int getAll(ToolRunnable[] array, int i) {
            for (ToolRunnable runnable : this.list) {
                array[i++] = runnable;
            }
            array[i++] = this.insertRunnable;
            return i;
        }
    }

    private static class RankedItem {
        final ToolRunnable runnable;
        final int rank;

        public RankedItem(ToolRunnable runnable, int rank) {
            this.runnable = runnable;
            this.rank = rank;
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            RankedItem other = (RankedItem)obj;
            return this.runnable.equals(other.runnable);
        }
    }

    private static class RunnableInfoStatus
    extends InfoStatus
    implements RunnableStatus {
        private final ToolRunnable runnable;

        public RunnableInfoStatus(int code, String message, ToolRunnable runnable) {
            super("org.eclipse.statet.nico.core", code, message);
            this.runnable = runnable;
        }

        public ToolRunnable getRunnable() {
            return this.runnable;
        }
    }

    private static class RunnableOkStatus
    extends OkStatus
    implements RunnableStatus {
        private final ToolRunnable runnable;

        public RunnableOkStatus(String message, ToolRunnable runnable) {
            super("org.eclipse.statet.nico.core", "OK");
            this.runnable = runnable;
        }

        public ToolRunnable getRunnable() {
            return this.runnable;
        }
    }

    public static interface Section {
    }

    public static final class StateDelta {
        public final byte oldState;
        public final byte newState;

        private StateDelta(byte oldState, byte newState) {
            this.oldState = oldState;
            this.newState = newState;
        }
    }

    private static abstract class SubQueue
    implements Section {
        protected final LinkedList<ToolRunnable> list = new LinkedList();
        private @Nullable SubQueue next;
        private boolean state;

        private SubQueue() {
        }

        public abstract int getAllSize();

        public abstract int getAll(ToolRunnable[] var1, int var2);

        public int getStartIdx() {
            int idx = 0;
            SubQueue next = this.next;
            while (next != null) {
                idx += next.getAllSize();
                next = next.next;
            }
            return idx;
        }

        public int getAppendIdx() {
            return this.getStartIdx() + this.list.size();
        }

        public void append(ImList<ToolRunnable> runnables) {
            if (runnables.size() == 1) {
                this.list.add((ToolRunnable)runnables.get(0));
            } else {
                this.list.addAll((Collection<ToolRunnable>)runnables);
            }
        }

        public void append(ToolRunnable runnable) {
            this.list.add(runnable);
        }

        public void dispose() {
            this.state = true;
            this.list.clear();
            this.next = null;
        }

        public boolean isDispose() {
            return this.state;
        }
    }

    public static final class TaskDelta {
        public final int type;
        public final int position;
        public final ImList<ToolRunnable> data;

        private TaskDelta(int type, int position, ImList<ToolRunnable> data) {
            this.type = type;
            this.position = position;
            this.data = data;
        }
    }

    private static final class TopLevelQueue
    extends SubQueue {
        @Override
        public int getAllSize() {
            return this.list.size();
        }

        @Override
        public int getAll(ToolRunnable[] array, int i) {
            for (ToolRunnable runnable : this.list) {
                array[i++] = runnable;
            }
            return i;
        }
    }
}

