/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.http.RunResult;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.console.AbstractRConsoleRunnable;
import org.eclipse.statet.rj.ts.core.console.RConsoleService;

@NonNullByDefault
public class RunExamplesRunnable
extends AbstractRConsoleRunnable {
    public static final String RUN_EXAMPLES_TASK_ID = "org.eclipse.statet.r.rhelp/RunExamples";
    private final RHelpPage helpPage;
    private Tool tool;
    private @Nullable RunResult result;

    public RunExamplesRunnable(RHelpPage helpPage) {
        super(RUN_EXAMPLES_TASK_ID, String.format("Run Examples of '%1$s'", helpPage));
        this.helpPage = helpPage;
    }

    public RHelpPage getHelpPage() {
        return this.helpPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable RunResult waitForResult() throws InterruptedException {
        RunExamplesRunnable runExamplesRunnable = this;
        synchronized (runExamplesRunnable) {
            if (this.result == null) {
                ((Object)((Object)this)).wait(60000L);
            }
            ((Object)((Object)this)).notifyAll();
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RunExamplesRunnable runExamplesRunnable = this;
        synchronized (runExamplesRunnable) {
            this.tool.getQueue().remove((ToolRunnable)this);
            if (this.result == null) {
                this.result = new RunResult(Status.CANCEL_STATUS, null);
            }
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changed(int event, Tool tool) {
        Status status;
        switch (event) {
            case 272: 
            case 273: {
                this.tool = tool;
                if (!tool.isTerminated()) {
                    return true;
                }
            }
            case 288: 
            case 290: 
            case 344: {
                status = Status.CANCEL_STATUS;
                break;
            }
            case 336: 
            case 340: {
                status = null;
                break;
            }
            default: {
                return true;
            }
        }
        RunExamplesRunnable runExamplesRunnable = this;
        synchronized (runExamplesRunnable) {
            if (this.result == null) {
                if (status == null) {
                    status = new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when running the examples.");
                }
                this.result = new RunResult(status, null);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(RConsoleService r, ProgressMonitor m) throws StatusException {
        RunExamplesRunnable runExamplesRunnable = this;
        synchronized (runExamplesRunnable) {
            if (this.result != null) {
                return;
            }
        }
        try {
            String line;
            RCharacterStore codelines = (RCharacterStore)RDataUtils.checkRCharVector((RObject)r.createFunctionCall("utils::example").addChar("topic", (String)this.helpPage.getTopics().getFirst()).addChar("package", this.helpPage.getPackage().getName()).addLogi("character.only", true).addLogi("give.lines", true).evalData(m)).getData();
            int startIdx = 0;
            int endIdx = RDataUtils.checkIntLength((RStore)codelines);
            while (startIdx < endIdx) {
                if (!codelines.isNA(startIdx)) {
                    line = codelines.getChar(startIdx);
                    if (!line.isEmpty() && !line.startsWith("### ")) break;
                    if (line.startsWith("### ** Examples")) {
                        ++startIdx;
                        break;
                    }
                }
                ++startIdx;
            }
            while (startIdx < endIdx) {
                if (!codelines.isNA(startIdx) && !(line = codelines.getChar(startIdx)).isEmpty()) break;
                ++startIdx;
            }
            while (endIdx > startIdx) {
                if (!codelines.isNA(endIdx - 1) && !(line = codelines.getChar(endIdx - 1)).isEmpty()) break;
                --endIdx;
            }
            r.briefAboutToChange();
            r.handleStatus((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Examples of '%1$s'", this.helpPage)), m);
            FunctionCall isPkgAttachedFCall = r.createFunctionCall("%in%").addChar("x", this.helpPage.getPackage().getName()).add("table", "base::.packages()");
            if (!RDataUtils.isSingleLogiTrue((RObject)isPkgAttachedFCall.evalData(m))) {
                r.submitToConsole("# First load the package", m);
                r.submitToConsole(String.format("library(\"%1$s\")", this.helpPage.getPackage().getName()), m);
                if (!RDataUtils.isSingleLogiTrue((RObject)isPkgAttachedFCall.evalData(m))) {
                    return;
                }
                r.briefChanged(16);
                r.submitToConsole("", m);
                r.briefAboutToChange();
            }
            int idx = startIdx;
            while (idx < endIdx) {
                if (m.isCanceled()) {
                    throw new StatusException(Status.CANCEL_STATUS);
                }
                if (!codelines.isNA(idx)) {
                    String line2 = codelines.getChar(idx);
                    r.submitToConsole(line2, m);
                }
                ++idx;
            }
            RunExamplesRunnable runExamplesRunnable2 = this;
            synchronized (runExamplesRunnable2) {
                this.result = new RunResult(Status.OK_STATUS, null);
                ((Object)((Object)this)).notifyAll();
            }
        }
        catch (UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when running examples of R help.", (Throwable)e));
        }
    }
}

