/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;

@NonNullByDefault
public abstract class AbstractRCodeGenerator {
    protected static final RTypedExpr R_NUM_ZERO_EXPR = new RTypedExpr("r", "0");
    protected static final IRExprProcessor DIRECT_PROCESSOR = new IRExprProcessor(){

        @Override
        public String getValue(RTypedExpr expr) {
            return expr.getExpr();
        }
    };
    protected static final IRExprProcessor TEXT_PROCESSOR = new IRExprProcessor(){

        @Override
        public String getValue(RTypedExpr expr) {
            return AbstractRCodeGenerator.quoteChar(expr.getExpr());
        }
    };
    protected static final IRExprProcessor QUOTE_PROCESSOR = new IRExprProcessor(){

        @Override
        public String getValue(RTypedExpr expr) {
            return AbstractRCodeGenerator.quoteChar(expr.getExpr());
        }
    };
    protected final List<String> requiredPkgs = new ArrayList<String>();
    protected final StringBuilder builder = new StringBuilder();
    private final String newLine = "\n";
    private final String mainAssign = " <- ";
    private final String argAssign = " = ";
    private final int indent = 0;

    protected static String quoteChar(String s) {
        StringBuilder result = new StringBuilder(s.length());
        result.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i++);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append('\\');
                    result.append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    protected void reset() {
        this.requiredPkgs.clear();
        this.builder.setLength(0);
    }

    protected void addRequirePackage(String pkgName) {
        if (!this.requiredPkgs.contains(pkgName)) {
            this.requiredPkgs.add(pkgName);
            FunBuilder fun = this.appendFun("library");
            fun.append(null, pkgName);
            fun.close();
            this.appendNewLine();
        }
    }

    protected void appendNewLine() {
        this.builder.append("\n");
    }

    protected void appendAssign(String to) {
        this.builder.append(to);
        this.builder.append(" <- ");
    }

    protected FunBuilder appendFun(String funName) {
        return new FunBuilder(this.builder.length(), funName);
    }

    protected void appendExprList(List<? extends RTypedExpr> list, String op, String empty) {
        this.appendExprList(list, DIRECT_PROCESSOR, op, empty);
    }

    protected void appendExprList(List<? extends RTypedExpr> list, IRExprProcessor processor, String op, @Nullable String empty) {
        int offset = this.builder.length();
        int i = 0;
        while (i < list.size()) {
            RTypedExpr expr = list.get(i);
            if (expr.getTypeKey() == "map") {
                if (this.builder.length() > offset) {
                    this.builder.append(op);
                }
                this.builder.append(processor.getValue(list.get(i)));
            }
            ++i;
        }
        if (this.builder.length() == offset && empty != null) {
            this.builder.append(empty);
        }
    }

    protected void appendExprsC(List<? extends RTypedExpr> list, IRExprProcessor processor) {
        this.builder.append("c(");
        this.appendExprList(list, processor, ", ", null);
        this.builder.append(")");
    }

    protected IRExprProcessor getRExprPRocessor(String typeKey) {
        if (typeKey == "chr") {
            return TEXT_PROCESSOR;
        }
        return DIRECT_PROCESSOR;
    }

    public abstract void generate(EObject var1);

    public List<String> getRequiredPkgs() {
        return ImCollections.toList(this.requiredPkgs);
    }

    public String getRCode() {
        return this.builder.toString();
    }

    protected class FunBuilder {
        private final int offset;
        private final int emtpyOffset;

        public FunBuilder(int offset, String funName) {
            this.offset = offset;
            AbstractRCodeGenerator.this.builder.append(funName);
            AbstractRCodeGenerator.this.builder.append('(');
            this.emtpyOffset = AbstractRCodeGenerator.this.builder.length();
        }

        public boolean isEmpty() {
            return AbstractRCodeGenerator.this.builder.length() == this.emtpyOffset;
        }

        public boolean append(@Nullable String argName, @Nullable String argValue) {
            if (argValue == null) {
                return false;
            }
            this.doAppendArg(argName, argValue);
            return true;
        }

        public boolean append(@Nullable String argName, @Nullable String argValue, boolean appendEmpty) {
            if (argValue == null && !appendEmpty) {
                return false;
            }
            this.doAppendArg(argName, argValue);
            return true;
        }

        public boolean appendEmpty(@Nullable String argName) {
            this.doAppendArg(argName, null);
            return true;
        }

        public boolean appendExpr(@Nullable String argName, @Nullable RTypedExpr argValue) {
            if (argValue == null) {
                return false;
            }
            this.doAppendArg(argName, AbstractRCodeGenerator.this.getRExprPRocessor(argValue.getTypeKey()).getValue(argValue));
            return true;
        }

        public boolean appendExpr(@Nullable String argName, RTypedExpr argValue, String requiredType) {
            if (argValue == null || argValue.getTypeKey() != requiredType) {
                return false;
            }
            this.doAppendArg(argName, AbstractRCodeGenerator.this.getRExprPRocessor(argValue.getTypeKey()).getValue(argValue));
            return true;
        }

        public boolean appendExpr(@Nullable String argName, RTypedExpr argValue, Collection<String> requiredTypes) {
            if (argValue == null || !requiredTypes.contains(argValue.getTypeKey())) {
                return false;
            }
            this.doAppendArg(argName, AbstractRCodeGenerator.this.getRExprPRocessor(argValue.getTypeKey()).getValue(argValue));
            return true;
        }

        public FunBuilder appendFun(@Nullable String argName, String funName) {
            int offset = AbstractRCodeGenerator.this.builder.length();
            this.doAppendArg(argName, null);
            return new FunBuilder(offset, funName);
        }

        private void doAppendArg(@Nullable String argName, @Nullable String argValue) {
            if (!this.isEmpty()) {
                AbstractRCodeGenerator.this.builder.append(", ");
            }
            if (argName != null) {
                AbstractRCodeGenerator.this.builder.append(argName);
                AbstractRCodeGenerator.this.builder.append(" = ");
            }
            if (argValue != null) {
                AbstractRCodeGenerator.this.builder.append(argValue);
            }
        }

        public void close() {
            AbstractRCodeGenerator.this.builder.append(")");
        }

        public void closeOrRemove() {
            if (this.isEmpty()) {
                AbstractRCodeGenerator.this.builder.delete(this.offset, AbstractRCodeGenerator.this.builder.length());
                return;
            }
            AbstractRCodeGenerator.this.builder.append(")");
        }
    }

    protected static interface IRExprProcessor {
        public String getValue(RTypedExpr var1);
    }
}

