/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data.core;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SizeConfig
implements Persistable {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    private int defaultSize;
    private final Map<Long, Integer> defaultSizeMap = new TreeMap<Long, Integer>();
    private final Map<Long, Integer> sizeMap = new TreeMap<Long, Integer>();
    private final Map<Long, Boolean> resizablesMap = new TreeMap<Long, Boolean>();
    private boolean resizableByDefault = true;

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        properties.put(prefix + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        this.saveMap(this.defaultSizeMap, prefix + PERSISTENCE_KEY_DEFAULT_SIZES, properties);
        this.saveMap(this.sizeMap, prefix + PERSISTENCE_KEY_SIZES, properties);
        properties.put(prefix + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        this.saveMap(this.resizablesMap, prefix + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties);
    }

    private void saveMap(Map<Long, ?> map, String key, Map<String, String> properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Long index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.put(key, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        String persistedResizableDefault;
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.resizablesMap.clear();
        String persistedDefaultSize = properties.get(prefix + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (persistedDefaultSize != null && !persistedDefaultSize.isEmpty()) {
            this.defaultSize = Integer.parseInt(persistedDefaultSize);
        }
        if ((persistedResizableDefault = properties.get(prefix + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)) != null && !persistedResizableDefault.isEmpty()) {
            this.resizableByDefault = Boolean.parseBoolean(persistedResizableDefault);
        }
        this.loadBooleanMap(prefix + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(prefix + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(prefix + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
    }

    private void loadIntegerMap(String key, Map<String, String> properties, Map<Long, Integer> map) {
        String property = properties.get(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Long.valueOf(token.substring(0, separatorIndex)), Integer.valueOf(token.substring(separatorIndex + 1, token.length())));
            }
        }
    }

    private void loadBooleanMap(String key, Map<String, String> properties, Map<Long, Boolean> map) {
        String property = properties.get(key);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Long.valueOf(token.substring(0, separatorIndex)), Boolean.valueOf(token.substring(separatorIndex + 1, token.length())));
            }
        }
    }

    public void setDefaultSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSize = size;
    }

    public void setDefaultSize(long position, int size) {
        if (this.defaultSize < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSizeMap.put(position, size);
    }

    private int getDefaultSize(long position) {
        Integer size = this.defaultSizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.defaultSize;
    }

    public long getAggregateSize(long position) {
        if (position < 0L) {
            throw new PositionOutOfBoundsException(position);
        }
        if (position == 0L) {
            return 0L;
        }
        if (this.isAllPositionsSameSize()) {
            return position * (long)this.defaultSize;
        }
        long resizeAggregate = 0L;
        long resizedColumns = 0L;
        Map<Long, Integer> mapToUse = this.sizeMap;
        for (Long resizedPosition : mapToUse.keySet()) {
            if (resizedPosition >= position) break;
            ++resizedColumns;
            resizeAggregate += (long)mapToUse.get(resizedPosition).intValue();
        }
        return position * (long)this.defaultSize + (resizeAggregate - resizedColumns * (long)this.defaultSize);
    }

    public int getSize(long position) {
        Integer size = this.sizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.getDefaultSize(position);
    }

    public void setSize(long position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.isPositionResizable(position)) {
            this.sizeMap.put(position, size);
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(long position) {
        Boolean resizable = this.resizablesMap.get(position);
        if (resizable != null) {
            return resizable;
        }
        return this.resizableByDefault;
    }

    public void setPositionResizable(long position, boolean resizable) {
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0;
    }
}

