/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.persistence.StylePersistor;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.style.editor.ColumnStyleEditorDialog;
import org.eclipse.statet.ecommons.waltable.style.editor.DisplayColumnStyleEditorCommand;
import org.eclipse.statet.jcommons.collections.LongIterator;
import org.eclipse.swt.widgets.Display;

public class DisplayColumnStyleEditorCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnStyleEditorCommand>
implements Persistable {
    protected static final String PERSISTENCE_PREFIX = "userDefinedColumnStyle";
    protected static final String USER_EDITED_STYLE_LABEL = "USER_EDITED_STYLE_FOR_INDEX_";
    protected final SelectionLayer selectionLayer;
    protected ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private final ConfigRegistry configRegistry;
    protected ColumnStyleEditorDialog dialog;
    protected final Map<String, BasicStyle> stylesToPersist = new HashMap<String, BasicStyle>();

    public DisplayColumnStyleEditorCommandHandler(SelectionLayer selectionLayer, ColumnOverrideLabelAccumulator labelAccumulator, ConfigRegistry configRegistry) {
        this.selectionLayer = selectionLayer;
        this.columnLabelAccumulator = labelAccumulator;
        this.configRegistry = configRegistry;
    }

    @Override
    public boolean doCommand(DisplayColumnStyleEditorCommand command) {
        long columnIndexOfClick = command.getNattableLayer().getDim(Orientation.HORIZONTAL).getPositionId(command.columnPosition, command.columnPosition);
        LabelStack configLabels = new LabelStack();
        this.columnLabelAccumulator.addLabels(configLabels, columnIndexOfClick, 0L);
        configLabels.addLabel(this.getConfigLabel(columnIndexOfClick));
        BasicStyle clickedCellStyle = (BasicStyle)this.configRegistry.getAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, configLabels.getLabels());
        this.dialog = new ColumnStyleEditorDialog(Display.getCurrent().getActiveShell(), clickedCellStyle);
        this.dialog.open();
        if (this.dialog.isCancelPressed()) {
            return true;
        }
        this.applySelectedStyleToColumns(command, this.selectionLayer.getSelectedColumnPositions());
        return true;
    }

    @Override
    public Class<DisplayColumnStyleEditorCommand> getCommandClass() {
        return DisplayColumnStyleEditorCommand.class;
    }

    protected void applySelectedStyleToColumns(DisplayColumnStyleEditorCommand command, LRangeList columnPositions) {
        LongIterator columnIter = columnPositions.values().iterator();
        while (columnIter.hasNext()) {
            long position = columnIter.nextLong();
            long columnIndex = ((ForwardLayerDim)this.selectionLayer.getDim(Orientation.HORIZONTAL)).getPositionId(position, position);
            BasicStyle newColumnCellStyle = this.dialog.getNewColumnCellStyle();
            String configLabel = this.getConfigLabel(columnIndex);
            if (newColumnCellStyle == null) {
                this.stylesToPersist.remove(configLabel);
            } else {
                newColumnCellStyle.setAttributeValue(CellStyling.BORDER_STYLE, this.dialog.getNewColumnBorderStyle());
                this.stylesToPersist.put(configLabel, newColumnCellStyle);
            }
            this.configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, newColumnCellStyle, DisplayMode.NORMAL, configLabel);
            this.columnLabelAccumulator.registerColumnOverridesOnTop(columnIndex, configLabel);
        }
    }

    protected String getConfigLabel(long columnIndex) {
        return USER_EDITED_STYLE_LABEL + columnIndex;
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        prefix = (String)prefix + ".userDefinedColumnStyle";
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.contains(PERSISTENCE_PREFIX)) continue;
            long colIndex = this.parseColumnIndexFromKey(key);
            if (this.stylesToPersist.keySet().contains(this.getConfigLabel(colIndex))) continue;
            BasicStyle savedStyle = StylePersistor.loadStyle((String)prefix + "." + this.getConfigLabel(colIndex), properties);
            this.configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, DisplayMode.NORMAL, this.getConfigLabel(colIndex));
            this.stylesToPersist.put(this.getConfigLabel(colIndex), savedStyle);
            this.columnLabelAccumulator.registerColumnOverrides(colIndex, this.getConfigLabel(colIndex));
        }
    }

    protected long parseColumnIndexFromKey(String keyString) {
        int colLabelStartIndex = keyString.indexOf(USER_EDITED_STYLE_LABEL);
        String columnConfigLabel = keyString.substring(colLabelStartIndex, keyString.indexOf(46, colLabelStartIndex));
        int lastUnderscoreInLabel = columnConfigLabel.lastIndexOf(95, colLabelStartIndex);
        return Long.parseLong(columnConfigLabel.substring(lastUnderscoreInLabel + 1));
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        prefix = (String)prefix + ".userDefinedColumnStyle";
        for (Map.Entry<String, BasicStyle> labelToStyle : this.stylesToPersist.entrySet()) {
            BasicStyle style = labelToStyle.getValue();
            String label = labelToStyle.getKey();
            StylePersistor.saveStyle((String)prefix + "." + label, properties, style);
        }
    }
}

