/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.statet.internal.nico.ui.console.ControlMarker;
import org.eclipse.statet.internal.nico.ui.console.ExtStylingConfiguration;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartition;
import org.eclipse.statet.internal.nico.ui.console.StyleData;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

@NonNullByDefault
public class ExtStylingEngine {
    private boolean extStyling;
    private @Nullable ExtStylingConfiguration extStylingConfig;
    private @Nullable TextViewer currentViewer;

    public @Nullable ExtStylingConfiguration getConfig() {
        return this.extStylingConfig;
    }

    public void setExtStyling(@Nullable ExtStylingConfiguration config) {
        this.extStylingConfig = config;
    }

    public void beginRendering(boolean enableExtStyling, @Nullable TextViewer viewer) {
        this.extStyling = enableExtStyling;
        this.currentViewer = viewer;
    }

    public void endRendering() {
        this.extStyling = false;
        this.currentViewer = null;
    }

    public ArrayList<StyleRange> computeStyleRanges(List<NIConsolePartition> partitions) {
        ExtStylingConfiguration config = this.extStyling ? this.extStylingConfig : null;
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>(partitions.size());
        block0: for (NIConsolePartition partition : partitions) {
            int styleStart = partition.getOffset();
            Iterator<ControlMarker> controlMarkers = partition.getControlMarkers().iterator();
            StyleData styleData = partition.getInitalStyleData();
            while (styleStart < partition.getEndOffset()) {
                ControlMarker nextStyleMarker = ControlMarker.nextStyleMarker(controlMarkers);
                int styleEnd = nextStyleMarker != null ? nextStyleMarker.getOffset() : partition.getEndOffset();
                NIConsoleOutputStream stream = partition.getStream();
                StyleRange styleRange = new StyleRange(styleStart, styleEnd - styleStart, stream.getColor(), stream.getBackgroundColor(), stream.getFontStyle());
                if (styleData != null && config != null) {
                    this.applyStyle(styleRange, styleData, config);
                }
                styles.add(styleRange);
                styleStart = styleEnd;
                if (nextStyleMarker == null) continue block0;
                styleData = nextStyleMarker.getStyle();
            }
        }
        return styles;
    }

    private void applyStyle(StyleRange styleRange, StyleData styleData, ExtStylingConfiguration config) {
        if (styleData.isEmpty()) {
            return;
        }
        Color foregroundColor = config.getSwtColor(styleData.getForegroundColor());
        Color backgroundColor = config.getSwtColor(styleData.getBackgroundColor());
        if (styleData.getInvert()) {
            if (foregroundColor == null) {
                foregroundColor = this.getDefaultForegroundColor(styleRange);
            }
            if (backgroundColor == null) {
                backgroundColor = this.getDefaultBackgroundColor(styleRange);
            }
            if (backgroundColor != null && foregroundColor != null) {
                Color color = foregroundColor;
                foregroundColor = backgroundColor;
                backgroundColor = color;
            }
        }
        if (styleData.getHide()) {
            if (backgroundColor == null) {
                backgroundColor = this.getDefaultBackgroundColor(styleRange);
            }
            if (backgroundColor != null) {
                foregroundColor = backgroundColor;
            }
        }
        if (foregroundColor != null) {
            styleRange.foreground = foregroundColor;
        }
        if (backgroundColor != null) {
            styleRange.background = backgroundColor;
        }
        styleRange.fontStyle = 0;
        if (styleData.getBold()) {
            styleRange.fontStyle |= 1;
        }
        if (styleData.getItalic()) {
            styleRange.fontStyle |= 2;
        }
        switch (styleData.getUnderline()) {
            case 1: {
                styleRange.underline = true;
                styleRange.underlineStyle = 0;
                break;
            }
            case 2: {
                styleRange.underline = true;
                styleRange.underlineStyle = 1;
                break;
            }
        }
        if (styleData.getStrikethrough()) {
            styleRange.strikeout = true;
        }
        if (styleData.getFramed()) {
            styleRange.borderStyle = 1;
        }
    }

    private @Nullable Color getDefaultForegroundColor(StyleRange styleRange) {
        TextViewer viewer;
        Color color = styleRange.foreground;
        if (color == null && (viewer = this.currentViewer) != null) {
            color = viewer.getTextWidget().getForeground();
        }
        return color;
    }

    private @Nullable Color getDefaultBackgroundColor(StyleRange styleRange) {
        TextViewer viewer;
        Color color = styleRange.background;
        if (color == null && (viewer = this.currentViewer) != null) {
            color = viewer.getTextWidget().getBackground();
        }
        return color;
    }
}

