/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.r.REditor;
import org.eclipse.statet.internal.r.ui.editors.r.REditorInformationProvider;
import org.eclipse.statet.internal.r.ui.editors.r.REditorTextHover;
import org.eclipse.statet.internal.r.ui.editors.r.RQuickOutlineInformationProvider;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistProcessor;
import org.eclipse.statet.ltk.ui.sourceediting.presentation.CommentScanner;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.doc.RDocumentContentInfo;
import org.eclipse.statet.r.core.source.util.RBracketPairMatcher;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAutoEditStrategy;
import org.eclipse.statet.r.ui.sourceediting.RContentAssistProcessor;
import org.eclipse.statet.r.ui.sourceediting.RQuickAssistProcessor;
import org.eclipse.statet.r.ui.text.r.RDefaultTextStyleScanner;
import org.eclipse.statet.r.ui.text.r.RDoubleClickStrategy;
import org.eclipse.statet.r.ui.text.r.ROperatorSpecialScanner;
import org.eclipse.statet.r.ui.text.r.RoxygenScanner;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

@NonNullByDefault
public class RSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final @NonNull String[] CONTENT_TYPES = (String[])RDocumentConstants.R_CONTENT_TYPES.toArray(String[]::new);
    private RDoubleClickStrategy doubleClickStrategy;
    private RAutoEditStrategy autoEditStrategy;
    private RCoreAccess coreAccess;

    public RSourceViewerConfiguration(int flags, @Nullable IPreferenceStore store) {
        this((DocContentSections)RDocumentContentInfo.INSTANCE, flags, null, null, store, null);
    }

    public RSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, RSourceEditor sourceEditor, RCoreAccess access, @Nullable IPreferenceStore preferenceStore, PreferenceStoreTextStyleManager<TextAttribute> textStyles) {
        super(documentContentInfo, flags, (SourceEditor)sourceEditor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : RUIPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), LtkUIPreferences.getAssistPreferences());
        this.setTextStyles(textStyles);
    }

    protected void setCoreAccess(RCoreAccess access) {
        this.coreAccess = access != null ? access : RCore.getWorkbenchAccess();
    }

    protected RSourceEditor getSourceEditor() {
        return (RSourceEditor)super.getSourceEditor();
    }

    protected void initTextStyles() {
        this.setTextStyles(RUIPlugin.getInstance().getRTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("R.Default", new RDefaultTextStyleScanner(textStyles));
        this.addScanner("R.Op.Special", (ITokenScanner)new ROperatorSpecialScanner(textStyles));
        this.addScanner("R.String", (ITokenScanner)new SingleTokenScanner(textStyles, "text_R_rString"));
        this.addScanner("R.Comment", (ITokenScanner)new CommentScanner(textStyles, "text_R_rComment", "text_R_taskTag", this.coreAccess.getPrefs()));
        this.addScanner("R.Roxygen", (ITokenScanner)new RoxygenScanner(textStyles, this.coreAccess.getPrefs()));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType == "R.QuotedSymbol") {
            contentType = "R.String";
        }
        return super.getScanner(contentType);
    }

    public RCoreAccess getRCoreAccess() {
        return this.coreAccess;
    }

    public List<SourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.autoEditStrategy != null) {
            addons.add(this.autoEditStrategy);
        }
        return addons;
    }

    public @NonNull String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public CharPairMatcher createPairMatcher() {
        return new RBracketPairMatcher(RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new RDoubleClickStrategy(RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
        }
        return this.doubleClickStrategy;
    }

    public @NonNull String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    protected IIndentSettings getIndentSettings() {
        return this.coreAccess.getRCodeStyle();
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)EPreferences.getInstancePrefs().getPreferenceValue((Preference)REditorOptions.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public @NonNull IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createRAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoEditStrategy};
    }

    protected RAutoEditStrategy createRAutoEditStrategy() {
        return new RAutoEditStrategy(this.coreAccess, this.getSourceEditor());
    }

    public @Nullable IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy spellingStrategy;
        RSourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1) && !(editor instanceof ConsolePageEditor)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2((SourceEditor)editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        if (editor instanceof REditor && (spellingStrategy = this.getSpellingStrategy(sourceViewer)) != null) {
            reconciler.addReconcilingStrategy(spellingStrategy);
        }
        return reconciler;
    }

    protected IReconcilingStrategy getSpellingStrategy(ISourceViewer sourceViewer) {
        if (!((Boolean)this.coreAccess.getPrefs().getPreferenceValue((Preference)REditorOptions.PREF_SPELLCHECKING_ENABLED)).booleanValue() || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        return new SpellingReconcileStrategy(sourceViewer, spellingService);
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = RUIPlugin.getInstance().getREditorContentAssistRegistry();
        RContentAssistProcessor processor = new RContentAssistProcessor(assistant, "R.Default", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'$', '@'});
        processor.setContextInformationAutoActivationCharacters(new char[]{','});
        assistant.setContentAssistProcessor((ContentAssist.Processor)processor);
        processor = new RContentAssistProcessor(assistant, "R.QuotedSymbol", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((ContentAssist.Processor)processor);
        processor = new RContentAssistProcessor(assistant, "R.String", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((ContentAssist.Processor)processor);
        processor = new RContentAssistProcessor(assistant, "R.Comment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((ContentAssist.Processor)processor);
        processor = new RContentAssistProcessor(assistant, "R.Roxygen", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'@', '\\'});
        assistant.setContentAssistProcessor((ContentAssist.Processor)processor);
    }

    protected @Nullable QuickAssistProcessor createQuickAssistProcessor() {
        RSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new RQuickAssistProcessor(editor);
        }
        return null;
    }

    protected boolean isInfoHoverDefaultContentType(String contentType) {
        return RDocumentConstants.R_CODE_CONTENT_CONSTRAINT.matches(contentType);
    }

    protected InfoHoverRegistry getInfoHoverRegistry() {
        return RUIPlugin.getInstance().getREditorInfoHoverRegistry();
    }

    protected @Nullable ITextHover createInfoHover(InfoHoverDescriptor descriptor) {
        RSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new REditorTextHover(editor, descriptor, this);
        }
        return null;
    }

    protected @Nullable EditorInformationProvider getInformationProvider() {
        RSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new REditorInformationProvider(editor);
        }
        return null;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.r.editorHyperlinks.REditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected @Nullable IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        RSourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new RQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }
}

