/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSessionFactory;
import org.eclipse.statet.jcommons.net.core.RSAccessSessionService;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class BasicRSAccessSessionService
implements RSAccessSessionService,
Disposable {
    private static final byte STARTED = 1;
    private static final byte STOPPED = 2;
    private static final RSAccessClientSession CONNECTING = new SessionDummy();
    private final Map<RemoteTarget, RSAccessClientSession> pool = new HashMap<RemoteTarget, RSAccessClientSession>();
    private final RSAccessClientSessionFactory<?> clientSessionFactory;
    private final RSAccessClientSession.Listener clientSessionListener;
    private byte state = 1;

    public BasicRSAccessSessionService(RSAccessClientSessionFactory<?> clientSessionFactory) {
        this.clientSessionFactory = clientSessionFactory;
        this.clientSessionListener = this::onSessionChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ImList<RSAccessClientSession> sessions;
        BasicRSAccessSessionService basicRSAccessSessionService = this;
        synchronized (basicRSAccessSessionService) {
            if (this.state == 2) {
                return;
            }
            this.state = (byte)2;
            sessions = ImCollections.toList(this.pool.values());
            this.pool.clear();
        }
        for (RSAccessClientSession session : sessions) {
            session.disconnect();
        }
        if (this.clientSessionFactory instanceof Disposable) {
            ((Disposable)((Object)this.clientSessionFactory)).dispose();
        }
    }

    protected void checkLive() throws StatusException {
        if (this.state != 1) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "The remote session service is shutdown."));
        }
    }

    @Override
    public RSAccessClientSession getClientSession(RemoteTarget target, ProgressMonitor m) throws StatusException {
        m.beginTask(String.format("Getting %1$s connection to '%2$s'", target.getType(), target.getHost()), 10);
        RSAccessClientSession session = this.getClientSession0(target, m);
        m.done();
        return session;
    }

    /*
     * Exception decompiling
     */
    protected RSAccessClientSession getClientSession0(RemoteTarget target, ProgressMonitor m) throws StatusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected RSAccessClientSession createClientSession(RemoteTarget target, ProgressMonitor m) throws StatusException {
        return this.clientSessionFactory.createSession(target, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSessionChanged(RSAccessClientSession.Event event) {
        switch (event.getType()) {
            case DISCONNECT: {
                BasicRSAccessSessionService basicRSAccessSessionService = this;
                synchronized (basicRSAccessSessionService) {
                    this.notifyAll();
                    this.pool.remove(event.getSession().getTarget());
                }
                return;
            }
        }
    }

    private static class SessionDummy
    implements RSAccessClientSession {
        private SessionDummy() {
        }

        @Override
        public RemoteTarget getTarget() {
            return null;
        }

        @Override
        public void addListener(RSAccessClientSession.Listener listener) {
        }

        @Override
        public void removeListener(RSAccessClientSession.Listener listener) {
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public void disconnect() {
        }

        @Override
        public RemoteProcess exec(ProcessConfig processConfig, ProgressMonitor m) throws StatusException {
            return null;
        }

        @Override
        public Socket createDirectTcpIpSocket(InetSocketAddress targetAddress, ProgressMonitor m) throws StatusException {
            return null;
        }

        @Override
        public Socket createDirectTcpIpSocket(Port targetPort, ProgressMonitor m) throws StatusException {
            return null;
        }

        @Override
        public PortForwardingL allocatePortForwardingL(InetSocketAddress targetAddress) throws StatusException {
            return null;
        }

        @Override
        public PortForwardingL allocatePortForwardingL(Port remotePort) throws StatusException {
            return null;
        }

        @Override
        public void releasePortForwarding(PortForwardingL handle) throws StatusException {
        }
    }
}

