/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.update;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibPaths;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.runtime.BasicRPkgManagerData;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPathsLoader;
import org.eclipse.statet.rj.renv.runtime.RuntimeRPkgInfoLoader;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RPkgManagerImpl
implements RPkgManager {
    private final REnv rEnv;
    private int requested;
    private @Nullable RPkgManagerDataset dataset;
    private @Nullable RuntimeRPkgInfoLoader rPkgInfoLoader;

    public RPkgManagerImpl(REnv rEnv) {
        this.rEnv = rEnv;
    }

    public REnv getREnv() {
        return this.rEnv;
    }

    protected void beginRTask(RService r, ProgressMonitor m) throws StatusException {
    }

    protected void endRTask() {
    }

    public void check(int flags, RService r, ProgressMonitor m) throws StatusException {
        this.runUpdate(flags, r, m);
    }

    protected int checkRequest(int request) {
        request = RPkgManager.expandFlags((int)request);
        return request;
    }

    public synchronized int request(int request) {
        request = this.checkRequest(request);
        this.requested |= request;
        RPkgManagerDataset dataset = this.getDataset();
        if (dataset != null && (dataset.getProviding() & request) == request) {
            return 0;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(RService r, ProgressMonitor m) throws StatusException {
        this.beginRTask(r, m);
        try {
            int requested;
            RPkgManagerImpl rPkgManagerImpl = this;
            synchronized (rPkgManagerImpl) {
                requested = this.requested;
            }
            this.runUpdate(requested, r, m);
        }
        finally {
            this.endRTask();
        }
    }

    public synchronized @Nullable RPkgManagerDataset getDataset() {
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runUpdate(int flags, RService r, ProgressMonitor m) throws StatusException {
        REnvConfiguration rEnvConfig = (REnvConfiguration)this.rEnv.get(REnvConfiguration.class);
        if (rEnvConfig == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "R environment configuration is missing."));
        }
        RuntimeRLibPathsLoader loader = new RuntimeRLibPathsLoader(rEnvConfig);
        RuntimeRLibPaths rLibPaths = loader.load(0, r, m);
        RuntimeRPkgInfoLoader rPkgInfoLoader = this.rPkgInfoLoader;
        if (rPkgInfoLoader == null) {
            this.rPkgInfoLoader = rPkgInfoLoader = new RuntimeRPkgInfoLoader();
        }
        RPkgCompilation newInstalled = rPkgInfoLoader.loadInstalled(rLibPaths, null, null, r, m);
        RPkgManagerImpl rPkgManagerImpl = this;
        synchronized (rPkgManagerImpl) {
            this.dataset = new BasicRPkgManagerData(this.rEnv, 1, (RLibPaths)rLibPaths, newInstalled);
            this.requested &= 0xFFFFFBFF;
        }
    }
}

