/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.ImagePainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class CheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image uncheckedImg;

    public CheckBoxPainter() {
        this.checkedImg = GUIHelper.getImage("checked");
        this.uncheckedImg = GUIHelper.getImage("unchecked");
    }

    public CheckBoxPainter(Image checkedImg, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.uncheckedImg = uncheckedImg;
    }

    public long getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public long getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.isChecked(cell, configRegistry) ? this.checkedImg : this.uncheckedImg;
    }

    protected boolean isChecked(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        if (cell.getDataValue(0, null) instanceof Boolean) {
            return (Boolean)cell.getDataValue(0, null);
        }
        IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Boolean convertedValue = null;
        if (displayConverter != null) {
            convertedValue = (Boolean)displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue(0, null));
        }
        if (convertedValue == null) {
            convertedValue = Boolean.FALSE;
        }
        return convertedValue;
    }
}

