/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.LaunchShortcutUtil;
import org.eclipse.statet.internal.r.debug.ui.launcher.RSourceCodeAdapter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.launching.RCodeLaunching;

public class SubmitSelectionHandler
extends AbstractHandler {
    private final boolean fGotoConsole;
    private RRefactoringAdapter fModelUtil;

    public SubmitSelectionHandler() {
        this(false);
    }

    protected SubmitSelectionHandler(boolean gotoConsole) {
        this.fGotoConsole = gotoConsole;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block9: {
            ISelection selection;
            block10: {
                block8: {
                    selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
                    if (!(selection instanceof ITextSelection)) break block8;
                    List<String> lines = LaunchShortcutUtil.getSelectedCodeLines(event);
                    if (lines != null) {
                        RCodeLaunching.runRCodeDirect(lines, this.fGotoConsole, null);
                        return null;
                    }
                }
                if (!(selection instanceof IStructuredSelection)) break block9;
                SourceStructElement[] elements = LTKSelectionUtils.getSelectedSourceStructElements((ISelection)selection);
                if (elements == null) break block10;
                if (this.fModelUtil == null) {
                    this.fModelUtil = new RSourceCodeAdapter();
                }
                ArrayList lines = TextUtil.toLines((String)this.fModelUtil.getSourceCodeStringedTogether(elements, null));
                RCodeLaunching.runRCodeDirect(lines, this.fGotoConsole, null);
                return null;
            }
            try {
                IFile[] files = LTKSelectionUtils.getSelectedFiles((ISelection)selection);
                if (files != null) {
                    int last = files.length - 1;
                    int i = 0;
                    while (i <= last) {
                        List<String> lines = LaunchShortcutUtil.getCodeLines(files[i]);
                        RCodeLaunching.runRCodeDirect(lines, i == last && this.fGotoConsole, null);
                        ++i;
                    }
                    return null;
                }
            }
            catch (CoreException e) {
                LaunchShortcutUtil.handleRLaunchException(e, RLaunchingMessages.RSelectionLaunch_error_message, event);
                return null;
            }
        }
        LaunchShortcutUtil.handleUnsupportedExecution(event);
        return null;
    }

    public static class AndGotoConsole
    extends SubmitSelectionHandler {
        public AndGotoConsole() {
            super(true);
        }
    }
}

