/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.validation;

import com.ibm.icu.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class IntegerValidator
implements IValidator<Object> {
    private final NumberFormat formatter;
    private final boolean allowEmpty;
    private final int min;
    private final int max;
    private final String message;

    public IntegerValidator(int min, int max, boolean allowEmpty, String message) {
        this.allowEmpty = allowEmpty;
        this.min = min;
        this.max = max;
        this.message = message;
        this.formatter = NumberFormat.getIntegerInstance();
        this.formatter.setParseIntegerOnly(true);
    }

    public IntegerValidator(int min, int max, String message) {
        this(min, max, false, message);
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            int n;
            String s = ((String)value).trim();
            if (this.allowEmpty && s.length() == 0) {
                return Status.OK_STATUS;
            }
            ParsePosition result = new ParsePosition(0);
            Number number = this.formatter.parse(s, result);
            if (result.getIndex() == s.length() && result.getErrorIndex() < 0 && (n = number.intValue()) >= this.min && n <= this.max) {
                return Status.OK_STATUS;
            }
        }
        return ValidationStatus.error((String)this.message);
    }
}

