/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.runtime;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.BasicRPkgBuilt;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.BasicRPkgList;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RuntimeRPkgInfoLoader {
    private static final String AVAIL_LIST_FNAME = "rj:::renv.getAvailPkgs";
    private static final int AVAIL_LIST_COUNT1 = 9;
    private static final int AVAIL_LIST_IDX1_NAME = 0;
    private static final int AVAIL_LIST_IDX1_VERSION = 1;
    private static final int AVAIL_LIST_IDX1_PRIORITY = 2;
    private static final int AVAIL_LIST_IDX1_LICENSE = 3;
    private static final int AVAIL_LIST_IDX1_DEPENDS = 4;
    private static final int AVAIL_LIST_IDX1_IMPORTS = 5;
    private static final int AVAIL_LIST_IDX1_LINKINGTO = 6;
    private static final int AVAIL_LIST_IDX1_SUGGESTS = 7;
    private static final int AVAIL_LIST_IDX1_ENHANCES = 8;
    private static final String INST_LIST_FNAME = "rj:::renv.getInstPkgs";
    private static final int INST_LIST_COUNT1 = 4;
    private static final int INST_LIST_IDX1_NAME = 0;
    private static final int INST_LIST_IDX1_VERSION = 1;
    private static final int INST_LIST_IDX1_TITLE = 2;
    private static final int INST_LIST_IDX1_BUILT = 3;
    private static final String INST_DETAIL_FNAME = "rj:::renv.getInstPkgDetail";
    private static final int INST_DETAIL_LENGTH = 7;
    private static final int INST_DETAIL_IDX_PRIORITY = 0;
    private static final int INST_DETAIL_IDX_LICENSE = 1;
    private static final int INST_DETAIL_IDX_DEPENDS = 2;
    private static final int INST_DETAIL_IDX_IMPORTS = 3;
    private static final int INST_DETAIL_IDX_LINKINGTO = 4;
    private static final int INST_DETAIL_IDX_SUGGESTS = 5;
    private static final int INST_DETAIL_IDX_ENHANCES = 6;

    public RPkgCompilation<RPkgBuilt> loadInstalled(RuntimeRLibPaths rLibPaths, boolean @Nullable [] update, @Nullable RPkgCompilation<RPkgBuilt> prevInstalled, RService r, ProgressMonitor m) throws StatusException {
        m.beginSubTask("Updating installed R packages...");
        try {
            BasicRPkgCompilation<RPkgBuilt> newInstalled = new BasicRPkgCompilation<RPkgBuilt>(rLibPaths.getRLibLocations().size());
            for (RLibLocation libLocation : rLibPaths.getRLibLocations()) {
                RLibLocationInfo locationInfo = rLibPaths.getInfo(libLocation);
                if (locationInfo == null || locationInfo.getLibPathsIndex() < 0 || newInstalled.getBySource(libLocation.getDirectory()) != null) continue;
                if (update == null || update[locationInfo.getLibPathsIndex()] || prevInstalled == null) {
                    RPkgBuilt oldPkg;
                    FunctionCall call = r.createFunctionCall(INST_LIST_FNAME);
                    call.addChar("lib", locationInfo.getDirectoryRPath());
                    RArray data = RDataUtils.checkRCharArray((RObject)call.evalData(m), (int)2);
                    RDataUtils.checkColumnCountEqual((RArray)data, (int)4);
                    RCharacterStore store = (RCharacterStore)data.getData();
                    int nPkgs = data.getDim().getInt(0);
                    RPkgList<RPkgBuilt> oldList = prevInstalled != null ? prevInstalled.getBySource(libLocation.getDirectory()) : null;
                    BasicRPkgList newList = new BasicRPkgList(nPkgs);
                    int idxPkg = 0;
                    while (idxPkg < nPkgs) {
                        String name = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)0L));
                        String version = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)1L));
                        if (name != null && !name.isEmpty() && version != null && !version.isEmpty()) {
                            RPkgBuilt newPkg;
                            name = name.intern();
                            String built = (String)ObjectUtils.nonNullElse((Object)store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)3L)), (Object)"");
                            RPkgBuilt rPkgBuilt = oldPkg = oldList != null ? oldList.get(name) : null;
                            if (oldPkg != null && oldPkg.getVersion().toString().equals(version) && oldPkg.getBuilt().equals(built)) {
                                newPkg = oldPkg;
                            } else {
                                String title = (String)ObjectUtils.nonNullElse((Object)store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)2L)), (Object)"");
                                newPkg = new BasicRPkgBuilt(name, RNumVersion.create(version), built, title, libLocation);
                            }
                            newList.add(newPkg);
                        }
                        ++idxPkg;
                    }
                    if (oldList != null) {
                        int i = 0;
                        int j = 0;
                        int in = oldList.size();
                        int jn = newList.size();
                        while (i < in) {
                            oldPkg = oldList.get(i++);
                            String name = oldPkg.getName();
                            if (j >= jn) continue;
                            if (((RPkgBuilt)newList.get(j)).getName() == name) {
                                ++j;
                                continue;
                            }
                            int idx = newList.indexOf(name, j + 1);
                            if (idx < 0) continue;
                            j = idx + 1;
                        }
                    }
                    newInstalled.add(libLocation.getDirectory(), newList);
                    continue;
                }
                RPkgList<RPkgBuilt> prevList = prevInstalled.getBySource(libLocation.getDirectory());
                if (prevList == null) continue;
                newInstalled.add(libLocation.getDirectory(), prevList);
            }
            return newInstalled;
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services", "An error occurred when loading list of installed R packages.", e));
        }
    }
}

