/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.issues.core.Problem;

@NonNullByDefault
public class BasicProblem
implements Problem {
    private final int line;
    private final int startOffset;
    private final int endOffset;
    private final String modelTypeId;
    private final int severity;
    private final int code;
    private final String message;

    public BasicProblem(String modelTypeId, int severity, int code, String message, int line, int startOffset, int endOffset) {
        this.modelTypeId = modelTypeId;
        this.severity = severity;
        this.code = code;
        this.message = message;
        this.line = line;
        this.startOffset = startOffset;
        this.endOffset = endOffset - startOffset > 0 ? endOffset : startOffset + 1;
    }

    public BasicProblem(String modelTypeId, int severity, int code, String message, int startOffset, int endOffset) {
        this.modelTypeId = modelTypeId;
        this.severity = severity;
        this.code = code;
        this.message = message;
        this.line = -1;
        this.startOffset = startOffset;
        this.endOffset = endOffset - startOffset > 0 ? endOffset : startOffset + 1;
    }

    @Override
    public String getCategoryId() {
        return this.modelTypeId;
    }

    @Override
    public int getSourceLine() {
        return this.line;
    }

    @Override
    public int getSourceStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getSourceEndOffset() {
        return this.endOffset;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

