/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineBorderDecorator
extends CellPainterWrapper {
    private final BorderStyle defaultBorderStyle;

    public LineBorderDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, null);
    }

    public LineBorderDecorator(ICellPainter interiorPainter, BorderStyle defaultBorderStyle) {
        super(interiorPainter);
        this.defaultBorderStyle = defaultBorderStyle;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        return super.getPreferredWidth(cell, gc, configRegistry) + padding * 2L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        return super.getPreferredHeight(cell, gc, configRegistry) + padding * 2L;
    }

    private BorderStyle getBorderStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        BorderStyle borderStyle = cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE);
        if (borderStyle == null) {
            borderStyle = this.defaultBorderStyle;
        }
        return borderStyle;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long padding = borderStyle != null ? Math.max(borderStyle.getOffset() + borderStyle.getThickness(), 0) : 0;
        LRectangle interiorBounds = new LRectangle(lRectangle.x + padding, lRectangle.y + padding, lRectangle.width - padding * 2L, lRectangle.height - padding * 2L);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        if (borderStyle == null || borderStyle.getThickness() <= 0) {
            return;
        }
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        int originalLineStyle = gc.getLineStyle();
        long borderOffset = borderStyle.getOffset();
        int borderThickness = borderStyle.getThickness();
        LRectangle borderArea = new LRectangle(lRectangle.x + borderOffset, lRectangle.y + borderOffset, lRectangle.width - borderOffset * 2L, lRectangle.height - borderOffset * 2L);
        long shift = 0L;
        long areaShift = 0L;
        if (borderThickness % 2 == 0) {
            shift = borderThickness / 2;
            areaShift = shift * 2L;
        } else {
            shift = borderThickness / 2;
            areaShift = shift * 2L + 1L;
        }
        borderArea.x += shift;
        borderArea.y += shift;
        borderArea.width -= areaShift;
        borderArea.height -= areaShift;
        gc.setLineWidth(borderThickness);
        gc.setLineStyle(SWTUtil.toSWT(borderStyle.getLineStyle()));
        gc.setForeground(borderStyle.getColor());
        gc.drawRectangle(GraphicsUtils.safe(borderArea));
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
        gc.setLineStyle(originalLineStyle);
    }
}

