/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.servi.node.PropertiesBean;

@NonNullByDefault
public class PoolConfig
implements PropertiesBean {
    public static final String BEAN_ID = "poolconfig";
    public static final long MINUTES = 60000L;
    public static final long SECONDS = 1000L;
    public static final String MAX_TOTAL_COUNT_ID = "max_total.count";
    public static final String MIN_IDLE_COUNT_ID = "min_idle.count";
    public static final String MAX_IDLE_COUNT_ID = "max_idle.count";
    public static final String MIN_IDLE_MILLIS_ID = "min_idle.millis";
    @Deprecated
    public static final String MIN_IDLE_TIME_ID = "min_idle.time";
    public static final String MAX_WAIT_MILLIS_ID = "max_wait.millis";
    @Deprecated
    public static final String MAX_WAIT_TIME_ID = "max_wait.time";
    public static final String MAX_USAGE_COUNT_ID = "max_usage.count";
    public static final String EVICT_TIMEOUT_ID = "eviction_timeout.millis";
    private static final long EVICT_TIMEOUT_DEFAULT = 1800000L;
    private int maxTotalCount = 20;
    private int minIdleCount = 1;
    private int maxIdleCount = 10;
    private long minIdleTime = 600000L;
    private long maxWaitTime = 3000L;
    private int maxUsageCount = 1000;
    private long evictTimeout = 1800000L;

    public static String getPoolName(String id) {
        return id + "-pool";
    }

    public PoolConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolConfig(PoolConfig config) {
        this();
        PoolConfig poolConfig = config;
        synchronized (poolConfig) {
            this.load(config);
        }
    }

    @Override
    public String getBeanId() {
        return BEAN_ID;
    }

    public synchronized void load(PoolConfig templ) {
        this.maxTotalCount = templ.maxTotalCount;
        this.minIdleCount = templ.minIdleCount;
        this.maxIdleCount = templ.maxIdleCount;
        this.minIdleTime = templ.minIdleTime;
        this.maxWaitTime = templ.maxWaitTime;
        this.maxUsageCount = templ.maxUsageCount;
        this.evictTimeout = templ.evictTimeout;
    }

    @Override
    public synchronized void load(Properties map) {
        this.maxTotalCount = Integer.parseInt(map.getProperty(MAX_TOTAL_COUNT_ID));
        this.minIdleCount = Integer.parseInt(map.getProperty(MIN_IDLE_COUNT_ID));
        this.maxIdleCount = Integer.parseInt(map.getProperty(MAX_IDLE_COUNT_ID));
        this.minIdleTime = Long.parseLong(Utils.getProperty(map, MIN_IDLE_MILLIS_ID, MIN_IDLE_TIME_ID));
        this.maxWaitTime = Long.parseLong(Utils.getProperty(map, MAX_WAIT_MILLIS_ID, MAX_WAIT_TIME_ID));
        this.maxUsageCount = Integer.parseInt(map.getProperty(MAX_USAGE_COUNT_ID));
        String s = map.getProperty(EVICT_TIMEOUT_ID);
        this.evictTimeout = s != null ? Long.parseLong(s) : 1800000L;
    }

    @Override
    public synchronized void save(Properties map) {
        map.setProperty(MAX_TOTAL_COUNT_ID, Integer.toString(this.maxTotalCount));
        map.setProperty(MIN_IDLE_COUNT_ID, Integer.toString(this.minIdleCount));
        map.setProperty(MAX_IDLE_COUNT_ID, Integer.toString(this.maxIdleCount));
        map.setProperty(MIN_IDLE_MILLIS_ID, Long.toString(this.minIdleTime));
        map.setProperty(MAX_WAIT_MILLIS_ID, Long.toString(this.maxWaitTime));
        map.setProperty(MAX_USAGE_COUNT_ID, Integer.toString(this.maxUsageCount));
        map.setProperty(EVICT_TIMEOUT_ID, Long.toString(this.evictTimeout));
    }

    public synchronized int getMaxTotalCount() {
        return this.maxTotalCount;
    }

    public synchronized void setMaxTotalCount(int count) {
        this.maxTotalCount = count;
    }

    public synchronized int getMinIdleCount() {
        return this.minIdleCount;
    }

    public synchronized void setMinIdleCount(int count) {
        this.minIdleCount = count;
    }

    public synchronized int getMaxIdleCount() {
        return this.maxIdleCount;
    }

    public synchronized void setMaxIdleCount(int count) {
        this.maxIdleCount = count;
    }

    public synchronized long getMinIdleTime() {
        return this.minIdleTime;
    }

    public synchronized void setMinIdleTime(long milliseconds) {
        this.minIdleTime = milliseconds;
    }

    public synchronized void setMaxWaitTime(long milliseconds) {
        this.maxWaitTime = milliseconds;
    }

    public synchronized long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public synchronized void setMaxUsageCount(int count) {
        this.maxUsageCount = count;
    }

    public synchronized int getMaxUsageCount() {
        return this.maxUsageCount;
    }

    public synchronized long getEvictionTimeout() {
        return this.evictTimeout;
    }

    public synchronized void setEvictionTimeout(long milliseconds) {
        this.evictTimeout = milliseconds;
    }

    @Override
    public synchronized boolean validate(@Nullable Collection<PropertiesBean.ValidationMessage> messages) {
        boolean valid = true;
        if (this.minIdleCount < 0) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MIN_IDLE_COUNT_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        if (this.maxTotalCount < 1) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_TOTAL_COUNT_ID, "Value must be > 0."));
            }
            valid = false;
        }
        if (this.maxIdleCount < 0) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_IDLE_COUNT_ID, "Value must be >= 0."));
            }
            valid = false;
        }
        if (this.minIdleCount >= 0 && this.maxIdleCount >= 0 && this.maxIdleCount < this.minIdleCount) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_IDLE_COUNT_ID, "Value must be >= {min_idle.count}."));
            }
            valid = false;
        }
        if (this.minIdleTime < 0L) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MIN_IDLE_MILLIS_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        if (this.maxWaitTime < 0L && this.maxUsageCount != -1) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_WAIT_MILLIS_ID, "Value must be >= 0 or == -1 (infinite)"));
            }
            valid = false;
        }
        if (this.maxUsageCount < 1 && this.maxUsageCount != -1) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_USAGE_COUNT_ID, "Value must be > 0 or == -1 (disable)"));
            }
            valid = false;
        }
        if (this.evictTimeout < 0L) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(EVICT_TIMEOUT_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        return valid;
    }
}

