/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.io.File;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;

public class BrowserDropAdapter
implements DropTargetListener {
    private final Browser browser;

    protected BrowserDropAdapter(Browser view) {
        this.browser = view;
    }

    private void validate(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && (event.operations & 4) == 4) {
            event.detail = 4;
            event.feedback = 1;
            return;
        }
        event.detail = 0;
    }

    public void dragEnter(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] files = (String[])event.data;
        if (files == null || files.length == 0) {
            return;
        }
        try {
            File f = new File(files[0]);
            this.browser.setUrl(f.toURL().toExternalForm());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

