/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.pkgmanager.Change;
import org.eclipse.statet.internal.r.core.pkgmanager.FullRPkgSet;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgChangeSet;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgInfoAndData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgListImpl;
import org.eclipse.statet.internal.r.core.pkgmanager.Util;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfo;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.pkgmanager.RPkgInfo;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.BasicRPkg;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;

final class RPkgScanner {
    private static final String AVAIL_LIST_FNAME = "rj:::renv.getAvailPkgs";
    private static final int AVAIL_LIST_COUNT1 = 9;
    private static final int AVAIL_LIST_IDX1_NAME = 0;
    private static final int AVAIL_LIST_IDX1_VERSION = 1;
    private static final int AVAIL_LIST_IDX1_PRIORITY = 2;
    private static final int AVAIL_LIST_IDX1_LICENSE = 3;
    private static final int AVAIL_LIST_IDX1_DEPENDS = 4;
    private static final int AVAIL_LIST_IDX1_IMPORTS = 5;
    private static final int AVAIL_LIST_IDX1_LINKINGTO = 6;
    private static final int AVAIL_LIST_IDX1_SUGGESTS = 7;
    private static final int AVAIL_LIST_IDX1_ENHANCES = 8;
    private static final String INST_LIST_FNAME = "rj:::renv.getInstPkgs";
    private static final int INST_LIST_COUNT1 = 4;
    private static final int INST_LIST_IDX1_NAME = 0;
    private static final int INST_LIST_IDX1_VERSION = 1;
    private static final int INST_LIST_IDX1_TITLE = 2;
    private static final int INST_LIST_IDX1_BUILT = 3;
    private static final String INST_DETAIL_FNAME = "rj:::renv.getInstPkgDetail";
    private static final int INST_DETAIL_LENGTH = 7;
    private static final int INST_DETAIL_IDX_PRIORITY = 0;
    private static final int INST_DETAIL_IDX_LICENSE = 1;
    private static final int INST_DETAIL_IDX_DEPENDS = 2;
    private static final int INST_DETAIL_IDX_IMPORTS = 3;
    private static final int INST_DETAIL_IDX_LINKINGTO = 4;
    private static final int INST_DETAIL_IDX_SUGGESTS = 5;
    private static final int INST_DETAIL_IDX_ENHANCES = 6;
    private final BasicRPkgCompilation<IRPkgData> expectedPkgs = new BasicRPkgCompilation<IRPkgData>(4){

        protected RPkgList<IRPkgData> newPkgList() {
            return new RPkgListImpl<IRPkgData>(4);
        }
    };

    private static @Nullable String decodeDescrField(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int mode = 0;
        int idxMode = 0;
        int idxDone = 0;
        StringBuilder sb = null;
        int idx = 0;
        while (idx < s.length()) {
            block0 : switch (s.charAt(idx)) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u007f': {
                    switch (mode) {
                        case 0: {
                            mode = 2;
                            idxMode = idx;
                            break block0;
                        }
                        case 1: {
                            mode = 2;
                            break block0;
                        }
                    }
                    break;
                }
                case ' ': {
                    switch (mode) {
                        case 0: {
                            mode = 1;
                            idxMode = idx;
                            break block0;
                        }
                        case 1: {
                            mode = 2;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    switch (mode) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            mode = 0;
                            break block0;
                        }
                    }
                    if (sb == null) {
                        sb = new StringBuilder(s.length());
                    }
                    sb.append(s, idxDone, idxMode);
                    sb.append(' ');
                    idxDone = idx + 1;
                    mode = 0;
                }
            }
            ++idx;
        }
        if (sb != null) {
            sb.append(s, idxDone, mode == 0 ? s.length() : idxMode);
            return sb.toString();
        }
        return mode == 0 ? s : s.substring(0, idxMode);
    }

    private static List<RPkg> parsePkgRefs(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RPkg> list = new ArrayList<RPkg>(4);
        String name = null;
        String version = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block0: while (i <= s.length()) {
            int j;
            int c;
            int n = c = i < s.length() ? (int)s.charAt(i) : -1;
            if (c == -1 || c == 44) {
                if (name != null) {
                    list.add((RPkg)new BasicRPkg(name, RNumVersion.create(version)));
                }
                name = null;
                version = null;
                ++i;
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                name = null;
                version = null;
                j = i + 1;
                while (true) {
                    int n2 = c = j < s.length() ? (int)s.charAt(j) : -1;
                    if (c < 0 || Character.isWhitespace(c) || c == 40 || c == 44) {
                        name = s.substring(i, j).intern();
                        i = j;
                        continue block0;
                    }
                    ++j;
                }
            }
            if (c == 40) {
                if (name == null || version != null) {
                    name = null;
                    version = null;
                }
                sb.setLength(0);
                boolean ws = false;
                j = ++i;
                while (true) {
                    int n3 = c = j < s.length() ? (int)s.charAt(j) : -1;
                    if (c < 0 || c == 41) {
                        version = sb.toString();
                        i = j + 1;
                        continue block0;
                    }
                    if (Character.isWhitespace(c)) {
                        ws = true;
                    } else {
                        if (ws) {
                            sb.append(' ');
                            ws = false;
                        }
                        sb.append((char)c);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    void addExpectedPkg(RLibLocation location, IRPkgData pkg) {
        String path = location.getDirectory();
        RPkgListImpl list = (RPkgListImpl)this.expectedPkgs.getOrAdd(path);
        list.set(pkg);
    }

    private void clearExpected() {
        List all = this.expectedPkgs.getAll();
        for (RPkgList list : all) {
            ((RPkgListImpl)list).clear();
        }
    }

    RPkgCompilation<IRPkgData> loadAvailable(REnv rEnv, ISelectedRepos repoSettings, RService r, ProgressMonitor m) throws StatusException {
        m.beginSubTask("Loading available R packages...");
        try {
            RCharacterStore repos = (RCharacterStore)RDataUtils.checkRCharVector((RObject)r.evalData("options('repos')[[1L]]", m)).getData();
            int l = RDataUtils.checkIntLength((RStore)repos);
            BasicRPkgCompilation newAvailable = new BasicRPkgCompilation(l);
            int idxRepos = 0;
            while (idxRepos < l) {
                String repoURL = repos.getChar(idxRepos);
                if (repoURL != null && !repoURL.isEmpty()) {
                    String key;
                    RRepo repo = Util.getRepoByURL(repoSettings.getRepos(), repoURL);
                    m.beginSubTask(NLS.bind((String)"Loading available R packages from {0}...", (Object)repoURL));
                    FunctionCall call = r.createFunctionCall(AVAIL_LIST_FNAME);
                    call.addChar("repo", repoURL);
                    if (repo.getPkgType() == null || (key = RPkgUtils.getPkgTypeInstallKey((RPlatform)r.getPlatform(), (RPkgType)repo.getPkgType())) != null) {
                        RArray data = RDataUtils.checkRCharArray((RObject)call.evalData(m), (int)2);
                        RDataUtils.checkColumnCountEqual((RArray)data, (int)9);
                        RCharacterStore store = (RCharacterStore)data.getData();
                        int nPkgs = data.getDim().getInt(0);
                        RPkgListImpl<RPkgData> list = new RPkgListImpl<RPkgData>(nPkgs);
                        newAvailable.add(repo.getId(), list);
                        int idxPkgs = 0;
                        while (idxPkgs < nPkgs) {
                            String name = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)0L));
                            String version = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)1L));
                            if (name != null && !name.isEmpty() && version != null) {
                                name = name.intern();
                                RPkgData pkg = new RPkgData(name, RNumVersion.create((String)version), repo.getId());
                                pkg.setLicense(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)3L)));
                                pkg.setDepends(RPkgScanner.parsePkgRefs(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)4L))));
                                pkg.setImports(RPkgScanner.parsePkgRefs(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)5L))));
                                pkg.setLinkingTo(RPkgScanner.parsePkgRefs(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)6L))));
                                pkg.setSuggests(RPkgScanner.parsePkgRefs(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)7L))));
                                pkg.setEnhances(RPkgScanner.parsePkgRefs(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)8L))));
                                pkg.setPriority(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkgs, (long)2L)));
                                list.add(pkg);
                            }
                            ++idxPkgs;
                        }
                    }
                }
                ++idxRepos;
            }
            return newAvailable;
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when loading list of available R packages.", e));
        }
    }

    RPkgCompilation<IRPkgInfo> loadInstalled(RuntimeRLibPaths rLibPaths, boolean[] update, Change event, RService r, ProgressMonitor m) throws StatusException {
        m.beginSubTask("Updating installed R packages...");
        try {
            RPkgChangeSet changeSet;
            BasicRPkgCompilation newInstalled = new BasicRPkgCompilation(rLibPaths.getRLibLocations().size());
            RPkgCompilation<? extends IRPkgInfo> prevInstalled = event.oldPkgs != null ? event.oldPkgs.getInstalled() : null;
            event.installedPkgs = changeSet = new RPkgChangeSet();
            for (RLibLocation libLocation : rLibPaths.getRLibLocations()) {
                RLibLocationInfo locationInfo = rLibPaths.getInfo(libLocation);
                if (locationInfo == null || locationInfo.getLibPathsIndex() < 0 || newInstalled.getBySource(libLocation.getDirectory()) != null) continue;
                if (update == null || update[locationInfo.getLibPathsIndex()] || prevInstalled == null) {
                    IRPkgInfo oldPkg;
                    FunctionCall call = r.createFunctionCall(INST_LIST_FNAME);
                    call.addChar("lib", locationInfo.getDirectoryRPath());
                    RArray data = RDataUtils.checkRCharArray((RObject)call.evalData(m), (int)2);
                    RDataUtils.checkColumnCountEqual((RArray)data, (int)4);
                    RCharacterStore store = (RCharacterStore)data.getData();
                    int nPkgs = data.getDim().getInt(0);
                    RPkgList oldList = prevInstalled != null ? prevInstalled.getBySource(libLocation.getDirectory()) : null;
                    RPkgListImpl<IRPkgInfo> newList = new RPkgListImpl<IRPkgInfo>(nPkgs);
                    RPkgList expectedList = this.expectedPkgs.getBySource(libLocation.getDirectory());
                    int idxPkg = 0;
                    while (idxPkg < nPkgs) {
                        String name = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)0L));
                        String version = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)1L));
                        if (name != null && !name.isEmpty() && version != null && !version.isEmpty()) {
                            IRPkgInfo newPkg;
                            boolean changed;
                            name = name.intern();
                            String built = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)3L));
                            if (built == null) {
                                built = "";
                            }
                            oldPkg = oldList != null ? (IRPkgInfo)oldList.get(name) : null;
                            boolean bl = changed = oldPkg == null || !oldPkg.getVersion().toString().equals(version) || !oldPkg.getBuilt().equals(built);
                            if (!changed) {
                                newPkg = oldPkg;
                            } else {
                                IRPkgData expectedData = expectedList != null ? (IRPkgData)expectedList.get(name) : null;
                                newPkg = new RPkgInfo(name, RNumVersion.create((String)version), built, RPkgScanner.decodeDescrField(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)2L))), libLocation, 0, event.stamp, expectedData != null ? expectedData.getRepoId() : null);
                                changeSet.names.add((Object)name);
                                if (oldPkg == null) {
                                    changeSet.added.add(newPkg);
                                } else {
                                    changeSet.changed.add(oldPkg);
                                }
                            }
                            newList.add(newPkg);
                        }
                        ++idxPkg;
                    }
                    if (oldList != null) {
                        int i = 0;
                        int j = 0;
                        int in = oldList.size();
                        int jn = newList.size();
                        while (i < in) {
                            oldPkg = (IRPkgInfo)oldList.get(i++);
                            String name = oldPkg.getName();
                            if (j < jn) {
                                if (((IRPkgInfo)newList.get(j)).getName() == name) {
                                    ++j;
                                    continue;
                                }
                                int idx = newList.indexOf(name, j + 1);
                                if (idx >= 0) {
                                    j = idx + 1;
                                    continue;
                                }
                            }
                            changeSet.names.add((Object)name);
                            changeSet.deleted.add(oldPkg);
                        }
                    }
                    newInstalled.add(libLocation.getDirectory(), newList);
                    continue;
                }
                RPkgList prevList = prevInstalled.getBySource(libLocation.getDirectory());
                if (prevList == null) continue;
                newInstalled.add(libLocation.getDirectory(), prevList);
            }
            this.clearExpected();
            return newInstalled;
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when loading list of installed R packages.", e));
        }
    }

    void updateInstFull(RuntimeRLibPaths rLibPaths, boolean[] update, FullRPkgSet newPkgs, Change event, RService r, ProgressMonitor m) throws StatusException {
        m.beginSubTask("Updating installed R packages...");
        try {
            RPkgChangeSet changeSet;
            FullRPkgSet oldFullPkgs = event.oldPkgs instanceof FullRPkgSet ? (FullRPkgSet)event.oldPkgs : null;
            event.installedPkgs = changeSet = new RPkgChangeSet();
            for (RLibLocation location : rLibPaths.getRLibLocations()) {
                RLibLocationInfo locationInfo = rLibPaths.getInfo(location);
                if (locationInfo == null || locationInfo.getLibPathsIndex() < 0) continue;
                if (update == null || update[locationInfo.getLibPathsIndex()] || oldFullPkgs == null) {
                    IRPkgInfo oldPkg;
                    FunctionCall call = r.createFunctionCall(INST_LIST_FNAME);
                    call.addChar("lib", locationInfo.getDirectoryRPath());
                    RArray data = RDataUtils.checkRCharArray((RObject)call.evalData(m), (int)2);
                    RDataUtils.checkColumnCountEqual((RArray)data, (int)4);
                    RCharacterStore store = (RCharacterStore)data.getData();
                    int nPkgs = data.getDim().getInt(0);
                    RPkgList oldList = event.oldPkgs != null ? event.oldPkgs.getInstalled().getBySource(location.getDirectory()) : null;
                    RPkgListImpl<RPkgInfoAndData> newList = new RPkgListImpl<RPkgInfoAndData>(nPkgs);
                    RPkgList expectedList = this.expectedPkgs.getBySource(location.getDirectory());
                    int idxPkg = 0;
                    while (idxPkg < nPkgs) {
                        String name = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)0L));
                        String version = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)1L));
                        if (name != null && !name.isEmpty() && version != null && !version.isEmpty()) {
                            RPkgInfoAndData newPkg;
                            boolean changed;
                            name = name.intern();
                            String built = store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)3L));
                            if (built == null) {
                                built = "";
                            }
                            oldPkg = oldList != null ? (IRPkgInfo)oldList.get(name) : null;
                            boolean bl = changed = oldPkg == null || !oldPkg.getVersion().toString().equals(version) || !oldPkg.getBuilt().equals(built);
                            if (!changed && oldPkg instanceof RPkgInfoAndData) {
                                newPkg = (RPkgInfoAndData)oldPkg;
                            } else {
                                IRPkgData expectedData = changed && expectedList != null ? (IRPkgData)expectedList.get(name) : null;
                                newPkg = new RPkgInfoAndData(name, !changed ? oldPkg.getVersion() : RNumVersion.create((String)version), built, RPkgScanner.decodeDescrField(store.getChar(RDataUtils.getDataIdx((long)nPkgs, (long)idxPkg, (long)2L))), location, !changed ? oldPkg.getFlags() : 0, !changed ? oldPkg.getInstallStamp() : event.stamp, !changed ? oldPkg.getRepoId() : (expectedData != null ? expectedData.getRepoId() : null));
                                FunctionCall call2 = r.createFunctionCall(INST_DETAIL_FNAME);
                                call2.addChar("lib", locationInfo.getDirectoryRPath());
                                call2.addChar("name", name);
                                RCharacterStore detail = (RCharacterStore)RDataUtils.checkRCharVector((RObject)call2.evalData(m)).getData();
                                RDataUtils.checkLengthEqual((RStore)detail, (long)7L);
                                newPkg.setPriority(detail.getChar(0));
                                newPkg.setLicense(detail.getChar(1));
                                newPkg.setDepends(RPkgScanner.parsePkgRefs(detail.getChar(2)));
                                newPkg.setImports(RPkgScanner.parsePkgRefs(detail.getChar(3)));
                                newPkg.setLinkingTo(RPkgScanner.parsePkgRefs(detail.getChar(4)));
                                newPkg.setSuggests(RPkgScanner.parsePkgRefs(detail.getChar(5)));
                                newPkg.setEnhances(RPkgScanner.parsePkgRefs(detail.getChar(6)));
                                if (changed) {
                                    changeSet.names.add((Object)name);
                                    if (oldPkg == null) {
                                        changeSet.added.add(newPkg);
                                    } else {
                                        changeSet.changed.add(oldPkg);
                                    }
                                }
                            }
                            newList.add(newPkg);
                        }
                        ++idxPkg;
                    }
                    if (oldList != null) {
                        int i = 0;
                        int j = 0;
                        int in = oldList.size();
                        int jn = newList.size();
                        while (i < in) {
                            oldPkg = (IRPkgInfo)oldList.get(i++);
                            String name = oldPkg.getName();
                            if (j < jn) {
                                if (((RPkgInfoAndData)newList.get(j)).getName() == name) {
                                    ++j;
                                    continue;
                                }
                                int idx = newList.indexOf(name, j + 1);
                                if (idx >= 0) {
                                    j = idx + 1;
                                    continue;
                                }
                            }
                            changeSet.names.add((Object)name);
                            changeSet.deleted.add(oldPkg);
                        }
                    }
                    newPkgs.getInstalled().add(location.getDirectory(), newList);
                    continue;
                }
                newPkgs.getInstalled().add(location.getDirectory(), oldFullPkgs.getInstalled().getBySource(location.getDirectory()));
            }
            return;
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when loading list of installed R packages.", e));
        }
    }
}

