/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.ltk.ui.wizards.LTKWizardsMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewElementWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IConfigurationElement configElement;

    public NewElementWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configElement = config;
    }

    protected abstract void performOperations(IProgressMonitor var1) throws InterruptedException, CoreException, InvocationTargetException;

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean canRunForked() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(this.getSchedulingRule()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        NewElementWizard.this.performOperations(monitor);
                    }
                    catch (InterruptedException e) {
                        throw new OperationCanceledException(e.getMessage());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        try {
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)op);
            return true;
        }
        catch (InvocationTargetException e) {
            this.handleTasksException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void handleTasksException(Shell shell, InvocationTargetException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, LTKWizardsMessages.NewElement_error_DuringOperation_message, (Throwable)e), 3);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected ISchedulingRule createRule(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.exists()) {
                return resource.getWorkspace().getRuleFactory().createRule(resource);
            }
            resource = parent;
            parent = parent.getParent();
        }
        return resource.getWorkspace().getRoot();
    }

    protected void openResource(IFile resource) {
        IWorkbenchPage activePage = UIAccess.getActiveWorkbenchPage((boolean)true);
        if (activePage != null) {
            LTKWorkbenchUIUtil.openEditor(activePage, resource, null);
        }
    }

    protected void openResource(NewFile file) {
        if (file.getResource() == null) {
            return;
        }
        IWorkbenchPage activePage = UIAccess.getActiveWorkbenchPage((boolean)true);
        if (activePage != null) {
            LTKWorkbenchUIUtil.openEditor(activePage, file.getResource(), file.getInitialSelection());
        }
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    protected static class NewContainer {
        private final IContainer container;

        public NewContainer(IContainer container) {
            this.container = container;
        }

        public NewContainer(IPath path) {
            this.container = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        }

        public IContainer getResource() {
            return this.container;
        }

        protected void createFolder(IContainer container, SubMonitor m) throws CoreException {
            if (container.getType() == 2 && !container.exists()) {
                ArrayList<IFolder> toCreate = new ArrayList<IFolder>();
                do {
                    toCreate.add((IFolder)container);
                } while ((container = container.getParent()).getType() == 2 && !container.exists());
                m.setWorkRemaining(toCreate.size());
                int i = toCreate.size() - 1;
                while (i >= 0) {
                    ((IFolder)toCreate.get(i)).create(false, true, (IProgressMonitor)m.newChild(1));
                    --i;
                }
            }
        }

        public IContainer createContainer(IProgressMonitor monitor) throws InterruptedException, CoreException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            IContainer handle = this.getResource();
            this.createFolder(handle, m);
            return handle;
        }

        public IFolder createSubFolder(IPath path, IProgressMonitor monitor) throws InterruptedException, CoreException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            IFolder handle = this.getResource().getFolder(path);
            this.createFolder((IContainer)handle, m);
            return handle;
        }
    }

    protected static class NewFile {
        protected IPath containerPath;
        protected String resourceName;
        private IContentType contentType;
        protected IRegion initialSelection;
        private IFile cachedHandle;

        public NewFile(IPath containerPath, String resourceName) {
            this.containerPath = containerPath;
            this.resourceName = resourceName;
        }

        public NewFile(IPath containerPath, String resourceName, IContentType contentType) {
            this(containerPath, resourceName);
            this.contentType = contentType != null ? contentType : Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        }

        public IFile getResource() {
            if (this.cachedHandle == null) {
                IPath fullPath = this.containerPath.append(this.resourceName);
                this.cachedHandle = this.createFileHandle(fullPath);
            }
            return this.cachedHandle;
        }

        protected IFile createFileHandle(IPath filePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }

        public void createFile(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
            IPath containerPath = this.containerPath;
            IFile newFileHandle = this.getResource();
            assert (containerPath != null);
            assert (newFileHandle != null);
            try {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)LTKWizardsMessages.NewElement_CreateFile_task, (Object)newFileHandle.getName()), (int)5);
                InputStream initialContents = this.getInitialFileContentStream(newFileHandle, m.newChild(1));
                ContainerGenerator generator = new ContainerGenerator(containerPath);
                generator.generateContainer((IProgressMonitor)m.newChild(1));
                NewFile.doCreateFile(newFileHandle, initialContents, m.newChild(3));
            }
            finally {
                monitor.done();
            }
        }

        private static void doCreateFile(IFile fileHandle, InputStream contents, SubMonitor m) throws CoreException {
            if (contents == null) {
                contents = new ByteArrayInputStream(new byte[0]);
            }
            try {
                m.beginTask(null, 30);
                IPath path = fileHandle.getFullPath();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int numSegments = path.segmentCount();
                if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                    SubMonitor m1 = m.newChild(10);
                    int i = numSegments - 2;
                    while (i > 0) {
                        m1.setWorkRemaining(i);
                        IFolder folder = root.getFolder(path.removeLastSegments(i));
                        if (!folder.exists()) {
                            folder.create(false, true, (IProgressMonitor)m1.newChild(1));
                        }
                        m1.worked(1);
                        --i;
                    }
                }
                if (m.isCanceled()) {
                    throw new OperationCanceledException();
                }
                m.setWorkRemaining(20);
                fileHandle.create(contents, false, (IProgressMonitor)m.newChild(20));
                if (m.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    fileHandle.refreshLocal(0, null);
                }
                throw e;
            }
        }

        protected InputStream getInitialFileContentStream(IFile newFileHandle, SubMonitor m) {
            String content = this.getInitialFileContent(newFileHandle, m);
            if (content == null) {
                return null;
            }
            try {
                String charset;
                IContentType contentType = this.getContentType(newFileHandle);
                if (contentType != null && (charset = contentType.getDefaultCharset()) != null) {
                    return new ByteArrayInputStream(content.getBytes(charset));
                }
                charset = newFileHandle.getCharset(true);
                if (charset != null) {
                    return new ByteArrayInputStream(content.getBytes(charset));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return new ByteArrayInputStream(content.getBytes());
        }

        public IContentType getContentType(IFile newFileHandle) {
            return this.contentType;
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor m) {
            return null;
        }

        public IRegion getInitialSelection() {
            return this.initialSelection;
        }
    }

    protected class NewProject {
        private final IProject project;
        protected IPath locationPath;
        private final IProject[] refProjects;
        private final IWorkingSet[] workingSets;

        public NewProject(IProject project, IPath location, IProject[] refProjects, IWorkingSet[] workingSets) {
            this.project = project;
            this.locationPath = location;
            this.refProjects = refProjects;
            this.workingSets = workingSets;
        }

        public IProject getResource() {
            return this.project;
        }

        public IProject createProject(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)LTKWizardsMessages.NewElement_CreateProject_task, (int)22);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(this.project.getName());
            description.setLocation(this.locationPath);
            if (this.refProjects != null && this.refProjects.length > 0) {
                description.setReferencedProjects(this.refProjects);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.doCreateProject(this.project, description, m.newChild(10));
            this.doConfigProject(this.project, (IProgressMonitor)m.newChild(10));
            this.doAddToWorkingSets(this.project, (IProgressMonitor)m.newChild(2));
            return this.project;
        }

        private void doCreateProject(IProject project, IProjectDescription description, SubMonitor m) throws CoreException {
            m.beginTask("Install Project", 20);
            project.create(description, (IProgressMonitor)m.newChild(10));
            if (m.isCanceled()) {
                throw new OperationCanceledException();
            }
            project.open((IProgressMonitor)m.newChild(10));
            if (m.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        protected void doConfigProject(IProject project, IProgressMonitor monitor) throws CoreException {
        }

        private void doAddToWorkingSets(IProject project, IProgressMonitor monitor) {
            if (this.workingSets != null && this.workingSets.length > 0) {
                monitor.beginTask(LTKWizardsMessages.NewElement_AddProjectToWorkingSet_task, 1);
                NewElementWizard.this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, this.workingSets);
            }
            monitor.done();
        }
    }
}

