/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.gui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.data.validate.IDataValidator;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditTypeEnum;
import org.eclipse.statet.ecommons.waltable.edit.editor.AbstractCellEditor;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.gui.CellEditDialog;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.tickupdate.ITickUpdateHandler;
import org.eclipse.statet.ecommons.waltable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TickUpdateCellEditDialog
extends CellEditDialog {
    private static final String SET = Messages.getString("TickUpdateCellEditDialog.set");
    private static final String INCREASE_BY = Messages.getString("TickUpdateCellEditDialog.increase");
    private static final String DECREASE_BY = Messages.getString("TickUpdateCellEditDialog.decrease");
    private static final String ADJUST_BY = Messages.getString("TickUpdateCellEditDialog.adjust");
    private static final String[] OPTIONS_DEFAULT = new String[]{SET, INCREASE_BY, DECREASE_BY};
    private static final String[] OPTIONS_ADJUST = new String[]{SET, ADJUST_BY};
    private final ITickUpdateHandler tickUpdateHandler;
    private Combo updateCombo;
    private EditTypeEnum editType = EditTypeEnum.SET;
    private final boolean useAdjustBy;
    private IDataValidator validator;

    public TickUpdateCellEditDialog(Shell parentShell, Object originalCanonicalValue, ILayerCell cell, ICellEditor cellEditor, IConfigRegistry configRegistry, ITickUpdateHandler tickUpdateHandler) {
        super(parentShell, originalCanonicalValue, cell, cellEditor, configRegistry);
        this.tickUpdateHandler = tickUpdateHandler;
        Boolean useAdjustByConfig = configRegistry.getConfigAttribute(TickUpdateConfigAttributes.USE_ADJUST_BY, DisplayMode.EDIT, cell.getConfigLabels().getLabels());
        this.useAdjustBy = useAdjustByConfig != null ? useAdjustByConfig : false;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        GridLayout panelLayout = new GridLayout(2, false);
        panelLayout.marginWidth = 8;
        panel.setLayout((Layout)panelLayout);
        this.createUpdateCombo(panel);
        this.cellEditor.activateCell(panel, this.originalCanonicalValue, EditMode.DIALOG, this.cellEditHandler, this.cell, this.configRegistry);
        this.validator = this.configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, this.cell.getConfigLabels().getLabels());
        if (this.cellEditor instanceof AbstractCellEditor) {
            ((AbstractCellEditor)this.cellEditor).setDataValidator(new TickUpdateDataValidatorWrapper(this.validator));
        }
        Control editorControl = this.cellEditor.getEditorControl();
        editorControl.addKeyListener(this.getEscKeyListener());
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 20).indent(5, 0).applyTo(editorControl);
        if (editorControl.getLayoutData() == null) {
            GridDataFactory.fillDefaults().grab(true, false).hint(100, 20).applyTo(editorControl);
        }
        return panel;
    }

    private void createUpdateCombo(Composite composite) {
        this.updateCombo = new Combo(composite, 2060);
        String[] stringArray = this.useAdjustBy ? OPTIONS_ADJUST : OPTIONS_DEFAULT;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.updateCombo.add(option);
            ++n2;
        }
        this.updateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = TickUpdateCellEditDialog.this.updateCombo.getSelectionIndex();
                if (TickUpdateCellEditDialog.this.useAdjustBy) {
                    switch (selectionIndex) {
                        case 1: {
                            TickUpdateCellEditDialog.this.editType = EditTypeEnum.ADJUST;
                        }
                    }
                } else {
                    switch (selectionIndex) {
                        case 1: {
                            TickUpdateCellEditDialog.this.editType = EditTypeEnum.INCREASE;
                            break;
                        }
                        case 2: {
                            TickUpdateCellEditDialog.this.editType = EditTypeEnum.DECREASE;
                        }
                    }
                }
            }
        });
        this.updateCombo.select(0);
        GridDataFactory.swtDefaults().applyTo((Control)this.updateCombo);
    }

    @Override
    public EditTypeEnum getEditType() {
        return this.editType;
    }

    @Override
    public Object calculateValue(Object currentValue, Object processValue) {
        double delta;
        double d = delta = processValue instanceof Number ? ((Number)processValue).doubleValue() : Double.valueOf((String)processValue).doubleValue();
        if (this.editType == EditTypeEnum.ADJUST) {
            this.editType = delta >= 0.0 ? EditTypeEnum.INCREASE : EditTypeEnum.DECREASE;
        }
        Object newValue = null;
        switch (this.editType) {
            case INCREASE: {
                newValue = this.tickUpdateHandler.getIncrementedValue(currentValue, delta);
                break;
            }
            case DECREASE: {
                newValue = this.tickUpdateHandler.getDecrementedValue(currentValue, delta);
            }
        }
        try {
            if (this.validator.validate(this.cell, this.configRegistry, newValue)) {
                return newValue;
            }
            WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Tick update failed for value " + newValue + ". New value is not valid!"));
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Tick update failed for value " + newValue + ". " + e.getLocalizedMessage()));
        }
        return currentValue;
    }

    private final class TickUpdateDataValidatorWrapper
    implements IDataValidator {
        IDataValidator wrappedValidator;

        TickUpdateDataValidatorWrapper(IDataValidator wrappedValidator) {
            this.wrappedValidator = wrappedValidator;
        }

        @Override
        public boolean validate(long columnIndex, long rowIndex, Object newValue) {
            if (TickUpdateCellEditDialog.this.editType == EditTypeEnum.SET) {
                return this.wrappedValidator.validate(columnIndex, rowIndex, newValue);
            }
            return true;
        }

        @Override
        public boolean validate(ILayerCell cell, IConfigRegistry configRegistry, Object newValue) {
            if (TickUpdateCellEditDialog.this.editType == EditTypeEnum.SET) {
                return this.wrappedValidator.validate(cell, configRegistry, newValue);
            }
            return true;
        }
    }
}

