/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;
import org.eclipse.statet.ecommons.waltable.resize.AutoResizePositionsCommand;
import org.eclipse.statet.ecommons.waltable.resize.InitializeAutoResizeCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class InitializeAutoResizeCommandHandler
extends AbstractLayerCommandHandler<InitializeAutoResizeCommand> {
    private final SelectionLayer selectionLayer;

    public InitializeAutoResizeCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<InitializeAutoResizeCommand> getCommandClass() {
        return InitializeAutoResizeCommand.class;
    }

    @Override
    protected boolean doCommand(InitializeAutoResizeCommand initCommand) {
        long position;
        ILayerDim layerDim = initCommand.getDim();
        long selectionPosition = LayerUtil.convertPosition(layerDim, position = initCommand.getPosition(), position, this.selectionLayer.getDim(layerDim.getOrientation()));
        if (selectionPosition != Long.MIN_VALUE && this.selectionLayer.isPositionFullySelected(layerDim.getOrientation(), position)) {
            LRangeList positions = this.selectionLayer.getFullySelectedPositions(layerDim.getOrientation());
            this.selectionLayer.doCommand(new AutoResizePositionsCommand(this.selectionLayer.getDim(layerDim.getOrientation()), positions));
        } else {
            LRangeList positions = new LRangeList(position);
            layerDim.getLayer().doCommand(new AutoResizePositionsCommand(layerDim, positions));
        }
        return true;
    }
}

