/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.selection.SelectRelativeCellCommand;
import org.eclipse.statet.ecommons.waltable.viewport.SelectRelativePageCommand;

public class SelectRelativePageCommandHandler
extends AbstractLayerCommandHandler<SelectRelativePageCommand> {
    private final ILayer viewportLayer;

    public SelectRelativePageCommandHandler(ILayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<SelectRelativePageCommand> getCommandClass() {
        return SelectRelativePageCommand.class;
    }

    @Override
    protected boolean doCommand(SelectRelativePageCommand command) {
        if (command.convertToTargetLayer(this.viewportLayer)) {
            long stepCount;
            switch (command.getDirection()) {
                case UP: 
                case DOWN: {
                    stepCount = this.viewportLayer.getRowCount();
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    stepCount = this.viewportLayer.getColumnCount();
                    break;
                }
                default: {
                    return false;
                }
            }
            this.viewportLayer.doCommand(new SelectRelativeCellCommand(command.getDirection(), stepCount, command.getSelectionFlags()));
        }
        return true;
    }
}

