/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRMethodBreakpoint;

public class RMethodBreakpoint
extends RLineBreakpoint
implements IRMethodBreakpoint {
    public static final String R_METHOD_BREAKPOINT_MARKER_TYPE = "org.eclipse.statet.r.resourceMarkers.RMethodBreakpoint";
    public static final String ENTRY_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.EntryBreakpointAttribute";
    public static final String EXIT_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ExitBreakpointAttribute";

    public RMethodBreakpoint(final IResource resource, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel, final boolean temporary) throws CoreException {
        final HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.addStandardLineBreakpointAttributes(attributes, true, lineNumber, charStart, charEnd, elementType, elementId, elementLabel, subLabel);
        attributes.put(ENTRY_MARKER_ATTR, Boolean.TRUE);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RMethodBreakpoint.this.setMarker(resource.createMarker(RMethodBreakpoint.R_METHOD_BREAKPOINT_MARKER_TYPE));
                RMethodBreakpoint.this.ensureMarker().setAttributes(attributes);
                RMethodBreakpoint.this.register(!temporary);
                if (temporary) {
                    RMethodBreakpoint.this.setPersisted(false);
                }
            }
        };
        this.run(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), wr);
    }

    public RMethodBreakpoint() {
    }

    @Override
    public String getBreakpointType() {
        return "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint";
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (this.isEnabled() != enabled) {
            if (enabled && !this.isEntry() && !this.isExit()) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", ENTRY_MARKER_ATTR}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            } else {
                this.setAttribute("org.eclipse.debug.core.enabled", enabled);
            }
        }
    }

    @Override
    public boolean isEntry() throws CoreException {
        return this.ensureMarker().getAttribute(ENTRY_MARKER_ATTR, true);
    }

    @Override
    public boolean isExit() throws CoreException {
        return this.ensureMarker().getAttribute(EXIT_MARKER_ATTR, false);
    }

    @Override
    public void setEntry(boolean enabled) throws CoreException {
        if (this.isEntry() != enabled) {
            if (!this.isEnabled() && enabled) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", ENTRY_MARKER_ATTR}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            } else if (!enabled && !this.isExit()) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", ENTRY_MARKER_ATTR}, new Object[]{Boolean.FALSE, Boolean.FALSE});
            } else {
                this.setAttribute(ENTRY_MARKER_ATTR, enabled);
            }
            this.update();
        }
    }

    @Override
    public void setExit(boolean enabled) throws CoreException {
        if (this.isExit() != enabled) {
            if (!this.isEnabled() && enabled) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", EXIT_MARKER_ATTR}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            } else if (!enabled && !this.isEntry()) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", EXIT_MARKER_ATTR}, new Object[]{Boolean.FALSE, Boolean.FALSE});
            } else {
                this.setAttribute(EXIT_MARKER_ATTR, enabled);
            }
            this.update();
        }
    }
}

