/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.AbstractRDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

public class RVectorDataAdapter
extends AbstractRDataAdapter<RVector<?>, RVector<?>> {
    @Override
    public RVector<?> validate(RObject rObject) throws UnexpectedRDataException {
        return RDataUtils.checkRVector((RObject)rObject);
    }

    @Override
    public RVector<?> validate(RObject rObject, RVector<?> referenceObject, int flags) throws UnexpectedRDataException {
        RVector vector = RDataUtils.checkRVector((RObject)rObject);
        if ((flags & 1) != 0) {
            RDataUtils.checkLengthEqual((RObject)vector, (long)referenceObject.getLength());
        }
        if ((flags & 4) != 0) {
            RDataUtils.checkData((RStore)vector.getData(), (byte)referenceObject.getData().getStoreType());
        }
        return vector;
    }

    @Override
    public long getRowCount(RVector<?> rObject) {
        return rObject.getLength();
    }

    @Override
    public long getColumnCount(RVector<?> rObject) {
        return 1L;
    }

    @Override
    protected String getLoadDataFName() {
        return "rj:::sda002.getDataVectorValues";
    }

    @Override
    protected String getSetDataFName() {
        return "rj:::sda002.setDataVectorValues";
    }

    @Override
    protected RVector<?> validateData(RObject rObject, RVector<?> referenceObject, LazyRStore.Fragment<RVector<?>> fragment) throws UnexpectedRDataException {
        RVector vector = RDataUtils.checkRVector((RObject)rObject);
        RDataUtils.checkLengthEqual((RObject)vector, (long)fragment.getRowCount());
        RDataUtils.checkData((RStore)rObject.getData(), (byte)referenceObject.getData().getStoreType());
        return vector;
    }

    @Override
    protected String getLoadRowNamesFName() {
        return "rj:::sda002.getDataVectorRowNames";
    }
}

