/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.runtime;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public interface RPkgManager {
    public static final int NONE = 0;
    public static final int INSTALLED = 1;
    public static final int AVAILABLE_REPOS = 16;
    public static final int AVAILABLE_PKGS = 32;
    public static final int AVAILABLE = 48;
    public static final int REFRESH_INSTALLED_PKGS = 1024;
    public static final int REFRESH_AVAILABLE_REPOS = 16384;
    public static final int REFRESH_AVAILABLE_PKGS = 32768;
    public static final int INITIAL = 0x100000;
    public static final int RESET = 0x200000;
    public static final int OK = 0;
    public static final int REQUIRES_CONFIG = 1;
    public static final int REQUIRES_UPDATE = 2;

    public static int expandFlags(int flags) {
        if ((0x4000 & flags) != 0) {
            flags |= 0x10;
        }
        if ((0x8000 & flags) != 0) {
            flags |= 0x30;
        }
        if ((0x400 & flags) != 0) {
            flags |= 1;
        }
        return flags;
    }

    public REnv getREnv();

    public void check(int var1, RService var2, ProgressMonitor var3) throws StatusException;

    public int request(int var1);

    public void update(RService var1, ProgressMonitor var2) throws StatusException;

    public @Nullable RPkgManagerDataset getDataset();

    default public RPkgManagerDataset getDataset(int request, RService r, ProgressMonitor m) throws StatusException {
        if (this.request(request) != 0) {
            this.update(r, m);
        }
        return (RPkgManagerDataset)ObjectUtils.nonNullAssert((Object)this.getDataset());
    }
}

