/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;

public class ForwardLayerDim<T extends ILayer>
extends AbstractLayerDim<T> {
    protected final ILayerDim underlyingDim;

    public ForwardLayerDim(T layer, ILayerDim underlyingDim) {
        this(layer, underlyingDim.getOrientation(), underlyingDim);
    }

    public ForwardLayerDim(T layer, Orientation orientation, ILayerDim underlyingDim) {
        super(layer, orientation);
        if (underlyingDim == null) {
            throw new NullPointerException("underlyingDim");
        }
        this.underlyingDim = underlyingDim;
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        return this.underlyingDim.getPositionId(refPosition, position);
    }

    @Override
    public long getPositionById(long id) {
        return this.underlyingDim.getPositionById(id);
    }

    @Override
    public long getPositionCount() {
        return this.underlyingDim.getPositionCount();
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        return position;
    }

    @Override
    public long underlyingToLocalPosition(ILayerDim sourceUnderlyingDim, long underlyingPosition) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        return underlyingPosition;
    }

    @Override
    public List<LRange> underlyingToLocalPositions(ILayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        return LRangeList.toRangeList(underlyingPositions);
    }

    @Override
    public List<ILayerDim> getUnderlyingDimsByPosition(long position) {
        return Collections.singletonList(this.underlyingDim);
    }

    @Override
    public long getSize() {
        return this.underlyingDim.getSize();
    }

    @Override
    public long getPreferredSize() {
        return this.underlyingDim.getPreferredSize();
    }

    @Override
    public long getPositionByPixel(long pixel) {
        return this.underlyingDim.getPositionByPixel(pixel);
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        return this.underlyingDim.getPositionStart(refPosition, position);
    }

    @Override
    public long getPositionStart(long position) {
        return this.underlyingDim.getPositionStart(position);
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        return this.underlyingDim.getPositionSize(refPosition, position);
    }

    @Override
    public int getPositionSize(long position) {
        return this.underlyingDim.getPositionSize(position);
    }

    @Override
    public boolean isPositionResizable(long position) {
        return this.underlyingDim.isPositionResizable(position);
    }
}

