/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.templates.WordFinder;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.ecommons.text.ui.settings.DecorationPreferences;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.InformationDispatchHandler;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class SourceEditorViewerConfiguration
extends TextSourceViewerConfiguration
implements ISettingsChangedHandler {
    static final boolean DEBUG = true;
    public static final int TEMPLATE_MODE = 8;
    public static final int COMPARE_MODE = 16;
    private static IInformationControlCreator assistTemplateInformationControlCreator;
    private static IInformationControlCreator assistDefaultInformationControlCreator;
    private static final IInformationControlCreator DEFAULT_INFORMATION_CONTROL_CREATOR;
    private static final ITextHover NO_HOVER;
    private final DocContentSections documentContentInfo;
    private final int flags;
    private final ISourceEditor editor;
    private TextStyleManager textStyles;
    private final CopyOnWriteIdentityListSet<ISettingsChangedHandler> settingsHandler = new CopyOnWriteIdentityListSet();
    private Map<String, ITokenScanner> scanners;
    private IPresentationReconciler presentationReconciler;
    private ICharPairMatcher pairMatcher;
    private ContentAssist contentAssistant;
    private IQuickAssistAssistant quickAssistant;
    private DecorationPreferences decorationPreferences;
    private AssistPreferences assistPreferences;
    private InfoHoverRegistry.EffectiveHovers infoHovers;
    private Map<Integer, ITextHover> infoHoverCache;

    static {
        DEFAULT_INFORMATION_CONTROL_CREATOR = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
        NO_HOVER = new ITextHover(){

            public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                return null;
            }

            public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                return null;
            }
        };
    }

    public SourceEditorViewerConfiguration(DocContentSections documentContentInfo, int flags, ISourceEditor sourceEditor) {
        if (documentContentInfo == null) {
            throw new NullPointerException("documentContentInfo");
        }
        this.documentContentInfo = documentContentInfo;
        this.flags = flags;
        this.editor = sourceEditor;
    }

    protected void setup(IPreferenceStore preferenceStore, DecorationPreferences decoPrefs, AssistPreferences assistPrefs) {
        assert (preferenceStore != null);
        this.fPreferenceStore = preferenceStore;
        this.decorationPreferences = decoPrefs;
        this.assistPreferences = assistPrefs;
    }

    public int getFlags() {
        return this.flags;
    }

    protected void initTextStyles() {
    }

    protected void setTextStyles(TextStyleManager textStyles) {
        this.textStyles = textStyles;
    }

    protected TextStyleManager getTextStyles() {
        if (this.textStyles == null) {
            this.initTextStyles();
        }
        return this.textStyles;
    }

    protected void initScanners() {
    }

    protected void addScanner(String contentType, ITokenScanner scanner) {
        this.scanners.put(contentType, scanner);
        if (scanner instanceof ISettingsChangedHandler) {
            this.settingsHandler.add((Object)((ISettingsChangedHandler)scanner));
        }
    }

    protected ITokenScanner getScanner(String contentType) {
        ITokenScanner scanner;
        if (this.scanners == null) {
            this.scanners = new HashMap<String, ITokenScanner>();
            this.initScanners();
        }
        if ((scanner = this.scanners.get(contentType)) == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.statet.ltk.ui", "No scanner for contentType= " + contentType + "."));
        }
        return scanner;
    }

    protected ISourceEditor getSourceEditor() {
        return this.editor;
    }

    public final DocContentSections getDocumentContentInfo() {
        return this.documentContentInfo;
    }

    public final String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return this.documentContentInfo.getPartitioning();
    }

    public IPreferenceStore getPreferences() {
        return this.fPreferenceStore;
    }

    public DecorationPreferences getDecorationPreferences() {
        return this.decorationPreferences;
    }

    public AssistPreferences getAssistPreferences() {
        return this.assistPreferences;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (this.assistPreferences != null && (groupIds.contains("Ltk/assist") || groupIds.contains(this.assistPreferences.getGroupId()))) {
            if (this.contentAssistant != null) {
                this.assistPreferences.configure(this.contentAssistant);
            }
            if (this.quickAssistant != null) {
                this.assistPreferences.configure(this.quickAssistant);
            }
        }
        if (this.textStyles != null && this.textStyles.affectsTextPresentation(groupIds)) {
            options.put("affects.Presentation", Boolean.TRUE);
        }
        for (ISettingsChangedHandler handler : this.settingsHandler.toList()) {
            handler.handleSettingsChanged(groupIds, options);
        }
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.presentationReconciler == null) {
            this.presentationReconciler = this.createPresentationReconciler();
        }
        return this.presentationReconciler;
    }

    protected IPresentationReconciler createPresentationReconciler() {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        this.initPresentationReconciler(reconciler);
        return reconciler;
    }

    PresentationReconciler getPresentationReconciler() {
        return (PresentationReconciler)this.presentationReconciler;
    }

    protected void initPresentationReconciler(PresentationReconciler reconciler) {
        String[] contentTypes;
        String[] stringArray = contentTypes = this.getConfiguredContentTypes(null);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            ITokenScanner scanner = this.getScanner(contentType);
            if (scanner != null) {
                DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
                reconciler.setDamager((IPresentationDamager)dr, contentType);
                reconciler.setRepairer((IPresentationRepairer)dr, contentType);
            }
            ++n2;
        }
    }

    public List<ISourceEditorAddon> getAddOns() {
        return new ArrayList<ISourceEditorAddon>();
    }

    public ICharPairMatcher getPairMatcher() {
        if (this.pairMatcher == null) {
            this.pairMatcher = this.createPairMatcher();
        }
        return this.pairMatcher;
    }

    protected ICharPairMatcher createPairMatcher() {
        return null;
    }

    protected IIndentSettings getIndentSettings() {
        return null;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        IIndentSettings settings = this.getIndentSettings();
        if (settings != null) {
            return settings.getTabSize();
        }
        return super.getTabWidth(sourceViewer);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        IIndentSettings settings = this.getIndentSettings();
        if (settings != null) {
            String[] prefixes = this.getIndentPrefixesForTab(this.getTabWidth(sourceViewer));
            if (settings.getIndentDefaultType() == IIndentSettings.IndentationType.SPACES) {
                int i = prefixes.length - 2;
                while (i > 0) {
                    prefixes[i] = prefixes[i - 1];
                    --i;
                }
                prefixes[0] = new String(IndentUtil.repeat((char)' ', (int)settings.getIndentSpacesCount()));
            }
            return prefixes;
        }
        return super.getIndentPrefixes(sourceViewer, contentType);
    }

    public boolean isSmartInsertSupported() {
        return false;
    }

    public boolean isSmartInsertByDefault() {
        return true;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.contentAssistant == null) {
            ContentAssist contentAssist = this.contentAssistant = (this.getFlags() & 8) != 0 ? this.createTemplateVariableContentAssistant(sourceViewer) : this.createContentAssistant(sourceViewer);
            if (this.contentAssistant != null) {
                if (this.assistPreferences != null) {
                    this.assistPreferences.configure(this.contentAssistant);
                }
                this.contentAssistant.setProposalPopupOrientation(10);
                this.contentAssistant.setContextInformationPopupOrientation(20);
                this.contentAssistant.setInformationControlCreator(this.getAssistInformationControlCreator(sourceViewer));
            }
        }
        return this.contentAssistant;
    }

    public ContentAssist getContentAssist() {
        return this.contentAssistant;
    }

    protected ContentAssist createContentAssistant(ISourceViewer sourceViewer) {
        if (this.getSourceEditor() != null) {
            ContentAssist assistant = new ContentAssist();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
            assistant.setRestoreCompletionProposalSize(DialogUtils.getDialogSettings((AbstractUIPlugin)LTKUIPlugin.getInstance(), (String)"ContentAssist.Proposal.size"));
            this.initContentAssist(assistant);
            return assistant;
        }
        return null;
    }

    protected void initContentAssist(ContentAssist assistant) {
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.quickAssistant == null) {
            this.quickAssistant = this.createQuickAssistant(sourceViewer);
            if (this.quickAssistant != null) {
                if (this.assistPreferences != null) {
                    this.assistPreferences.configure(this.quickAssistant);
                }
                this.quickAssistant.setInformationControlCreator(this.getAssistInformationControlCreator(sourceViewer));
            }
        }
        return this.quickAssistant;
    }

    protected IQuickAssistAssistant createQuickAssistant(ISourceViewer sourceViewer) {
        IQuickAssistProcessor processor = this.createQuickAssistProcessor();
        if (processor != null) {
            QuickAssistAssistant assistent = new QuickAssistAssistant();
            assistent.setQuickAssistProcessor(processor);
            assistent.enableColoredLabels(true);
            return assistent;
        }
        return super.getQuickAssistAssistant(sourceViewer);
    }

    protected IQuickAssistProcessor createQuickAssistProcessor() {
        return null;
    }

    protected IInformationControlCreator getAssistInformationControlCreator(ISourceViewer sourceViewer) {
        if ((this.getFlags() & 8) != 0) {
            if (assistTemplateInformationControlCreator == null) {
                assistTemplateInformationControlCreator = new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new DefaultInformationControl(parent, InformationDispatchHandler.getAdditionalInfoAffordanceString());
                    }
                };
            }
            return assistTemplateInformationControlCreator;
        }
        if (assistDefaultInformationControlCreator == null) {
            assistDefaultInformationControlCreator = new AssistInformationControlCreator();
        }
        return assistDefaultInformationControlCreator;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        if ((this.getFlags() & 8) != 0) {
            return new int[]{255};
        }
        if (this.getSourceEditor() != null) {
            return this.getInfoHoverStateMasks(contentType);
        }
        return super.getConfiguredTextHoverStateMasks(sourceViewer, contentType);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if ((this.getFlags() & 8) != 0) {
            return this.getTemplateVariableTextHover(sourceViewer);
        }
        return this.getInfoHover(sourceViewer, contentType, stateMask);
    }

    protected int[] getInfoHoverStateMasks(String contentType) {
        String[] contentTypes = this.getConfiguredContentTypes(null);
        if (contentTypes != null && contentTypes.length > 0 && contentTypes[0].equals(contentType)) {
            this.initInfoHovers();
        }
        if (this.infoHovers != null && this.isInfoHoverDefaultContentType(contentType)) {
            return this.infoHovers.getStateMasks();
        }
        return new int[]{255};
    }

    protected void initInfoHovers() {
        InfoHoverRegistry registry = this.getInfoHoverRegistry();
        InfoHoverRegistry.EffectiveHovers effectiveHovers = this.infoHovers = registry != null ? registry.getEffectiveHoverDescriptors() : null;
        if (this.infoHoverCache == null) {
            this.infoHoverCache = new HashMap<Integer, ITextHover>();
        } else {
            this.infoHoverCache.clear();
        }
    }

    public InfoHoverRegistry.EffectiveHovers getConfiguredInfoHovers() {
        return this.infoHovers;
    }

    protected ITextHover getInfoHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (this.infoHovers != null && this.isInfoHoverDefaultContentType(contentType)) {
            InfoHoverDescriptor descriptor;
            Integer key = stateMask;
            ITextHover hover = this.infoHoverCache.get(key);
            if (hover == null && (descriptor = this.infoHovers.getDescriptor(stateMask)) != null) {
                hover = this.createInfoHover(descriptor);
                if (hover == null) {
                    hover = NO_HOVER;
                }
                this.infoHoverCache.put(key, hover);
            }
            return hover != NO_HOVER ? hover : null;
        }
        return null;
    }

    protected boolean isInfoHoverDefaultContentType(String contentType) {
        String[] partitioning = this.getConfiguredContentTypes(null);
        return partitioning != null && partitioning.length > 0 && partitioning[0].equals(contentType);
    }

    protected InfoHoverRegistry getInfoHoverRegistry() {
        return null;
    }

    protected ITextHover createInfoHover(InfoHoverDescriptor descriptor) {
        return null;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(DEFAULT_INFORMATION_CONTROL_CREATOR);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        IInformationProvider provider = this.getInformationProvider();
        String[] contentTypes = this.getConfiguredContentTypes(null);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider(provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(100, 12, true, true);
        return presenter;
    }

    protected IInformationProvider getInformationProvider() {
        return null;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        this.collectHyperlinkDetectorTargets(targets, sourceViewer);
        return targets;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
    }

    public IInformationPresenter getQuickPresenter(ISourceViewer sourceViewer, int operation) {
        IInformationProvider provider = this.getQuickInformationProvider(sourceViewer, operation);
        if (provider == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(((IInformationProviderExtension2)provider).getInformationPresenterControlCreator());
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        presenter.setSizeConstraints(50, 20, true, false);
        String[] contentTypes = this.getConfiguredContentTypes(null);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider(provider, contentTypes[i]);
            ++i;
        }
        return presenter;
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        return null;
    }

    protected TemplateVariableProcessor getTemplateVariableProcessor() {
        throw new UnsupportedOperationException();
    }

    protected ContentAssist createTemplateVariableContentAssistant(ISourceViewer sourceViewer) {
        ContentAssist assistant = new ContentAssist();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        String[] stringArray = this.getConfiguredContentTypes(null);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            assistant.setContentAssistProcessor(this.getTemplateVariableProcessor(), contentType);
            ++n2;
        }
        return assistant;
    }

    public ITextHover getTemplateVariableTextHover(ISourceViewer sourceViewer) {
        ITextHover hover;
        Integer key = 0;
        if (this.infoHoverCache != null) {
            hover = this.infoHoverCache.get(key);
        } else {
            hover = new TemplateVariableTextHover(this.getTemplateVariableProcessor());
            this.infoHoverCache = Collections.singletonMap(key, hover);
        }
        return hover;
    }

    private static class AssistInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private AssistInformationControlCreator() {
        }

        protected IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                return new BrowserInformationControl(parent, "org.eclipse.jface.dialogfont", false){

                    public void setInformation(String content) {
                        if (content.startsWith("...<br")) {
                            content = content.replace("\\t", "    ");
                            StringBuffer s = new StringBuffer(content.length() + 1000);
                            s.append("<pre>");
                            s.append(content);
                            s.append("</pre>");
                            this.setInput((Object)new DefaultBrowserInformationInput(null, "", s.toString(), 1));
                        } else {
                            this.setInput((Object)new DefaultBrowserInformationInput(null, "", content, 2));
                        }
                    }
                };
            }
            return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }

    protected static class TemplateVariableTextHover
    implements ITextHover {
        private final TemplateVariableProcessor processor;

        public TemplateVariableTextHover(TemplateVariableProcessor processor) {
            this.processor = processor;
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
            try {
                IDocument doc = textViewer.getDocument();
                int offset = subject.getOffset();
                if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                    String varName = doc.get(offset, subject.getLength());
                    TemplateContextType contextType = this.processor.getContextType();
                    if (contextType != null) {
                        Iterator iter = contextType.resolvers();
                        while (iter.hasNext()) {
                            TemplateVariableResolver var = (TemplateVariableResolver)iter.next();
                            if (!varName.equals(var.getType())) continue;
                            return var.getDescription();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            if (textViewer != null) {
                return WordFinder.findWord(textViewer.getDocument(), offset);
            }
            return null;
        }
    }
}

