/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.util.WikitextCoreAccessWrapper;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.util.RCoreAccessWrapper;
import org.eclipse.statet.redocs.wikitext.r.core.source.WikidocRweaveDocumentSetupParticipant;
import org.eclipse.statet.redocs.wikitext.r.ui.sourceediting.WikidocRweaveSourceViewerConfiguration;

public class WikidocRweaveSourceViewerConfigurator
extends SourceEditorViewerConfigurator {
    private static final Set<String> RESET_GROUP_IDS = new HashSet<String>(Arrays.asList("Wikitext/Wikitext.codestyle/indent", "r/r.codestyle/indent", "statet.task_tags"));
    private final WikidocRweaveDocumentSetupParticipant documentSetup;
    private final WikitextCoreAccessWrapper docCoreAccess;
    private final RCoreAccessWrapper rCoreAccess;

    public WikidocRweaveSourceViewerConfigurator(WikidocRweaveDocumentSetupParticipant documentSetup, WikitextCoreAccess wikitextCoreAccess, RCoreAccess rCoreAccess, WikidocRweaveSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        this.documentSetup = documentSetup;
        this.docCoreAccess = new WikitextCoreAccessWrapper(wikitextCoreAccess){
            private final WikitextCodeStyleSettings codeStyle;
            {
                this.codeStyle = new WikitextCodeStyleSettings(1);
            }

            public WikitextCodeStyleSettings getWikitextCodeStyle() {
                return this.codeStyle;
            }
        };
        this.rCoreAccess = new RCoreAccessWrapper(rCoreAccess){
            private final RCodeStyleSettings codeStyle;
            {
                this.codeStyle = new RCodeStyleSettings(1);
            }

            public RCodeStyleSettings getRCodeStyle() {
                return this.codeStyle;
            }
        };
        config.setCoreAccess((WikitextCoreAccess)this.docCoreAccess, (RCoreAccess)this.rCoreAccess);
        this.docCoreAccess.getWikitextCodeStyle().load(this.docCoreAccess.getParent().getWikitextCodeStyle());
        this.docCoreAccess.getWikitextCodeStyle().resetDirty();
        this.docCoreAccess.getWikitextCodeStyle().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        this.rCoreAccess.getRCodeStyle().resetDirty();
        this.rCoreAccess.getRCodeStyle().addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public final IDocumentSetupParticipant getDocumentSetupParticipant() {
        return this.documentSetup;
    }

    public final WikitextCoreAccessWrapper getWikitextCoreAccess() {
        return this.docCoreAccess;
    }

    public final RCoreAccess getRCoreAccess() {
        return this.rCoreAccess;
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(WikitextCoreAccess wikitextCoreAccess, RCoreAccess rCoreAccess) {
        boolean changed = false;
        if (wikitextCoreAccess != null) {
            changed |= this.docCoreAccess.setParent(wikitextCoreAccess);
        }
        if (rCoreAccess != null) {
            changed |= this.rCoreAccess.setParent(rCoreAccess);
        }
        if (changed) {
            this.handleSettingsChanged(null, null);
        }
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.docCoreAccess.getWikitextCodeStyle().resetDirty();
        this.rCoreAccess.getRCodeStyle().resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("Wikitext/Wikitext.codestyle/indent")) {
            this.docCoreAccess.getWikitextCodeStyle().load(this.docCoreAccess.getParent().getWikitextCodeStyle());
        }
        if (groupIds.contains("r/r.codestyle/indent") || groupIds.contains("r/r.codestyle/ws")) {
            this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.redocs.wikitext.r/editor/Doc")) {
            this.updateCompleteConfig = true;
        }
        if (groupIds.contains("r/r.editor/hover")) {
            this.updateInfoHovers = true;
        }
    }
}

