/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core;

import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class JFaceTextRegion
extends BasicTextRegion
implements IRegion {
    public static final JFaceTextRegion toJFaceRegion(TextRegion region) {
        return region instanceof JFaceTextRegion ? (JFaceTextRegion)region : new JFaceTextRegion(region);
    }

    public static final JFaceTextRegion toTextRegion(IRegion region) {
        return region instanceof JFaceTextRegion ? (JFaceTextRegion)region : new JFaceTextRegion(region.getOffset(), region.getOffset() + region.getLength());
    }

    public static final JFaceTextRegion newByStartLength(int startOffset, int length) {
        return new JFaceTextRegion(startOffset, startOffset + length);
    }

    public static final JFaceTextRegion newByStartEnd(int startOffset, int endOffset) {
        return new JFaceTextRegion(startOffset, endOffset);
    }

    protected JFaceTextRegion(int startOffset, int endOffset) {
        super(startOffset, endOffset);
    }

    protected JFaceTextRegion(TextRegion region) {
        super(region);
    }

    public final int getOffset() {
        return this.getStartOffset();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TextRegion) {
            return super.equals(obj);
        }
        if (obj instanceof IRegion) {
            IRegion other = (IRegion)obj;
            return this.getOffset() == other.getOffset() && this.getLength() == other.getLength();
        }
        return false;
    }
}

