/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.text.ICodepointIterator;

public abstract class CharCodepointIterator
implements ICodepointIterator {
    private static final byte PREPARE_STEPBACK = 6;
    private final int fBeginIndex;
    private final int fEndIndex;
    private int fCurrentIndex;
    private int fCurrentCodepoint;
    private int fCurrentCharLength;

    public static CharCodepointIterator create(String string, int stringIndex, int beginIndex, int endIndex) throws BadLocationException {
        if (beginIndex > endIndex || beginIndex < stringIndex || endIndex > stringIndex + string.length()) {
            throw new BadLocationException();
        }
        return new StringIterator(string, stringIndex, beginIndex, endIndex);
    }

    public static CharCodepointIterator create(char[] array, int arrayIndex, int beginIndex, int endIndex) throws BadLocationException {
        if (beginIndex > endIndex || beginIndex < arrayIndex || endIndex > arrayIndex + array.length) {
            throw new BadLocationException();
        }
        return new CharArrayIterator(array, arrayIndex, beginIndex, endIndex);
    }

    protected CharCodepointIterator(int beginIndex, int endIndex) {
        this.fBeginIndex = beginIndex;
        this.fEndIndex = endIndex;
    }

    protected abstract char getChar(int var1, byte var2);

    @Override
    public final int first() {
        this.internalSet(this.fBeginIndex, (byte)1);
        return this.fCurrentCodepoint;
    }

    @Override
    public final int last() {
        this.internalSet(this.fBeginIndex < this.fEndIndex ? this.fEndIndex - 1 : this.fEndIndex, (byte)6);
        return this.fCurrentCodepoint;
    }

    @Override
    public final int current() {
        return this.fCurrentCodepoint;
    }

    @Override
    public final int next() {
        if (this.fCurrentIndex < this.fEndIndex) {
            this.internalSet(this.fCurrentIndex + this.fCurrentCharLength, (byte)1);
            return this.fCurrentCodepoint;
        }
        return -1;
    }

    public final int next(int count) {
        while (count > 0 && this.fCurrentIndex < this.fEndIndex) {
            this.internalSet(this.fCurrentIndex + this.fCurrentCharLength, (byte)1);
            --count;
        }
        return count == 0 ? this.fCurrentCodepoint : -1;
    }

    @Override
    public final int previous() {
        if (this.fCurrentIndex > this.fBeginIndex) {
            this.internalSet(this.fCurrentIndex - 1, (byte)6);
            return this.fCurrentCodepoint;
        }
        return -1;
    }

    public final int previous(int count) {
        while (count > 0 && this.fCurrentIndex > this.fBeginIndex) {
            this.internalSet(this.fCurrentIndex - 1, (byte)6);
            --count;
        }
        return count == 0 ? this.fCurrentCodepoint : -1;
    }

    @Override
    public void setIndex(int index, byte prepare) throws BadLocationException {
        if (index < this.fBeginIndex || index > this.fEndIndex) {
            throw new BadLocationException();
        }
        this.internalSet(index, prepare);
    }

    private final void internalSet(int index, byte prepare) {
        this.fCurrentIndex = index;
        if (this.fCurrentIndex < this.fEndIndex) {
            char c2;
            char c = this.getChar(this.fCurrentIndex, prepare);
            if ((prepare & 4) != 0 && Character.isLowSurrogate(c) && this.fCurrentIndex > this.fBeginIndex && Character.isHighSurrogate(c2 = this.getChar(this.fCurrentIndex - 1, prepare))) {
                --this.fCurrentIndex;
                this.fCurrentCodepoint = Character.toCodePoint(c2, c);
                this.fCurrentCharLength = 2;
            } else if (Character.isHighSurrogate(c) && this.fCurrentIndex + 1 < this.fEndIndex && Character.isLowSurrogate(c2 = this.getChar(this.fCurrentIndex + 1, prepare))) {
                this.fCurrentCodepoint = Character.toCodePoint(c, c2);
                this.fCurrentCharLength = 2;
            } else {
                this.fCurrentCodepoint = c;
                this.fCurrentCharLength = 1;
            }
        } else {
            this.fCurrentCodepoint = -1;
            this.fCurrentCharLength = 0;
        }
    }

    @Override
    public final int getBeginIndex() {
        return this.fBeginIndex;
    }

    @Override
    public final int getEndIndex() {
        return this.fEndIndex;
    }

    @Override
    public final int getCurrentIndex() {
        return this.fCurrentIndex;
    }

    @Override
    public final int getCurrentLength() {
        return this.fCurrentCharLength;
    }

    private static class CharArrayIterator
    extends CharCodepointIterator {
        private final char[] fArray;
        private final int fArrayOffset;

        public CharArrayIterator(char[] array, int arrayIndex, int beginIndex, int endIndex) throws BadLocationException {
            super(beginIndex, endIndex);
            this.fArray = array;
            this.fArrayOffset = arrayIndex;
        }

        @Override
        protected char getChar(int offset, byte prepare) {
            return this.fArray[offset - this.fArrayOffset];
        }

        public String toString() {
            return new String(this.fArray, this.getBeginIndex() - this.fArrayOffset, this.getEndIndex() - this.getBeginIndex());
        }
    }

    private static class StringIterator
    extends CharCodepointIterator {
        private final String fString;
        private final int fStringOffset;

        public StringIterator(String string, int stringIndex, int beginIndex, int endIndex) throws BadLocationException {
            super(beginIndex, endIndex);
            this.fString = string;
            this.fStringOffset = stringIndex;
        }

        @Override
        protected char getChar(int offset, byte prepare) {
            return this.fString.charAt(offset - this.fStringOffset);
        }

        public String toString() {
            return this.fString.substring(this.getBeginIndex() - this.fStringOffset, this.getEndIndex() - this.fStringOffset);
        }
    }
}

