/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.r.core.source.RDocumentConstants;
import org.eclipse.statet.r.debug.ui.actions.RToggleBreakpointAdapter;
import org.eclipse.statet.redocs.tex.r.ui.editors.LtxRweaveEditor;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private final RToggleBreakpointAdapter rAdapter = new RToggleBreakpointAdapter();

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        if (editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection) {
            if (this.isRChunk(editor, (ITextSelection)selection)) {
                this.rAdapter.toggleLineBreakpoints(part, selection);
            } else {
                this.rAdapter.removeBreakpoints(part, selection, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        if (editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection) {
            if (this.isRChunk(editor, (ITextSelection)selection)) {
                this.rAdapter.toggleMethodBreakpoints(part, selection);
            } else {
                this.rAdapter.removeBreakpoints(part, selection, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        return editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        LtxRweaveEditor editor = this.getREditor(part, selection);
        if (editor != null && editor.getSourceUnit() instanceof WorkspaceSourceUnit && selection instanceof ITextSelection) {
            if (this.isRChunk(editor, (ITextSelection)selection)) {
                this.rAdapter.toggleBreakpoints(part, selection);
            } else {
                this.rAdapter.removeBreakpoints(part, selection, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private LtxRweaveEditor getREditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof LtxRweaveEditor) {
            return (LtxRweaveEditor)part;
        }
        Object adapter = part.getAdapter(ISourceEditor.class);
        if (adapter instanceof LtxRweaveEditor) {
            return (LtxRweaveEditor)adapter;
        }
        return null;
    }

    private boolean isRChunk(LtxRweaveEditor editor, ITextSelection selection) {
        SourceViewer viewer = editor.getViewer();
        if (viewer != null) {
            try {
                ITypedRegion partition = ((IDocumentExtension3)viewer.getDocument()).getPartition(editor.getDocumentContentInfo().getPartitioning(), selection.getOffset(), false);
                return RDocumentConstants.R_ANY_CONTENT_CONSTRAINT.matches(partition.getType());
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPartitioningException badPartitioningException) {
                // empty catch block
            }
        }
        return false;
    }
}

