/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.ui.editors;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;
import org.eclipse.statet.yaml.core.model.YamlModel;
import org.eclipse.statet.yaml.core.source.YamlDocumentSetupParticipant;
import org.eclipse.statet.yaml.ui.editors.YamlEditorBuild;

@NonNullByDefault
public class YamlDocumentProvider
extends SourceDocumentProvider<SourceUnit>
implements Disposable {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("Yaml/editor/build")) {
                YamlDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryProblems;

    public YamlDocumentProvider() {
        super("Yaml", (PartitionerDocumentSetupParticipant)new YamlDocumentSetupParticipant());
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        this.handleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)YamlEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)YamlEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryProblems != newHandleTemporaryProblems) {
            this.handleTemporaryProblems = newHandleTemporaryProblems;
            if (this.handleTemporaryProblems) {
                YamlModel.getYamlModelManager().refresh(Ltk.EDITOR_CONTEXT);
            } else {
                List sus = LtkModels.getSourceUnitManager().getOpenSourceUnits("Yaml", Ltk.EDITOR_CONTEXT);
                for (SourceUnit su : sus) {
                    IAnnotationModel model = this.getAnnotationModel(su);
                    if (!(model instanceof ThisAnnotationModel)) continue;
                    ((ThisAnnotationModel)model).clearProblems(null);
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource);
        }

        protected boolean isHandlingTemporaryProblems() {
            return YamlDocumentProvider.this.handleTemporaryProblems;
        }

        protected @Nullable SourceProblemAnnotation createAnnotation(Problem problem) {
            if (problem.getCategoryId() == "Yaml") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.yaml.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            return null;
        }
    }
}

