/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.actions;

import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.debug.ui.config.actions.RunConfigsMenuContribution;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocActionUtil;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;

@NonNullByDefault
public class RunDocConfigsMenuContribution
extends RunConfigsMenuContribution<IFile>
implements IWorkbenchContribution,
IExecutableExtension {
    private @Nullable Matcher validExtMatcher;

    public RunDocConfigsMenuContribution() {
        super((ActionUtil)new DocActionUtil(2));
    }

    protected DocActionUtil getUtil() {
        return (DocActionUtil)super.getUtil();
    }

    protected List<ImIdentitySet<String>> getContextShortcutLaunchFlags() {
        return ImCollections.newList((Object[])new ImIdentitySet[]{DocProcessingUI.CommonFlags.PROCESS_AND_PREVIEW, DocProcessingUI.CommonFlags.PROCESS});
    }

    protected RunConfigsMenuContribution.ConfigContribution createConfigContribution(StringBuilder label, Image icon, ILaunchConfiguration configuration) {
        return new DocConfigContribution(label.toString(), icon, configuration);
    }

    private Matcher getValidExtMatcher(String ext) {
        if (this.validExtMatcher == null) {
            this.validExtMatcher = DocProcessingConfig.VALID_EXT_PATTERN.matcher(ext);
        } else {
            this.validExtMatcher.reset(ext);
        }
        return this.validExtMatcher;
    }

    protected @Nullable String resolveFormatExt(@Nullable DocProcessingConfig.Format format, @Nullable String inputExt) {
        if (format == null) {
            return null;
        }
        if (inputExt != null && (inputExt.isEmpty() || !this.getValidExtMatcher(inputExt).matches())) {
            inputExt = null;
        }
        return format.getExt(inputExt);
    }

    protected class DocConfigContribution
    extends RunConfigsMenuContribution.ConfigContribution {
        public DocConfigContribution(String label, Image icon, ILaunchConfiguration configuration) {
            super((RunConfigsMenuContribution)RunDocConfigsMenuContribution.this, label, icon, configuration);
        }

        protected void fillMenu(Menu menu) {
            this.addLaunchItems(menu);
            new MenuItem(menu, 2);
            this.addActivateItem(menu, "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsActivateConfig");
            this.addEditItem(menu, "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsEditConfig");
        }

        protected void addLaunchItems(Menu menu) {
        }

        protected @Nullable String createDetail(@Nullable String inputExt, @Nullable String outputExt) {
            if (inputExt == null || outputExt == null) {
                return null;
            }
            StringBuilder sb = RunDocConfigsMenuContribution.this.getStringBuilder();
            sb.append("\u2002[");
            sb.append(inputExt);
            sb.append("\u2002\u2192\u2002");
            sb.append(outputExt);
            sb.append("]");
            return sb.toString();
        }
    }
}

