/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.sort.ClearSortCommand;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.ecommons.waltable.sort.SortColumnEvent;
import org.eclipse.swt.custom.BusyIndicator;

public class ClearSortCommandHandler
implements ILayerCommandHandler<ClearSortCommand> {
    private final ISortModel sortModel;

    public ClearSortCommandHandler(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public Class<ClearSortCommand> getCommandClass() {
        return ClearSortCommand.class;
    }

    @Override
    public boolean doCommand(final ILayer targetLayer, ClearSortCommand command) {
        Runnable sortRunner = new Runnable(){

            @Override
            public void run() {
                ILayerDim dim = targetLayer.getDim(Orientation.HORIZONTAL);
                List<Long> sortedIds = ClearSortCommandHandler.this.sortModel.getSortedColumnIds();
                LRangeList sortedPositions = new LRangeList();
                for (Long id : sortedIds) {
                    long position = dim.getPositionById(id);
                    if (position == Long.MIN_VALUE) continue;
                    sortedPositions.values().add(position);
                }
                ClearSortCommandHandler.this.sortModel.clear();
                SortColumnEvent sortEvent = new SortColumnEvent(dim, (Collection<LRange>)sortedPositions);
                dim.getLayer().fireLayerEvent(sortEvent);
            }
        };
        BusyIndicator.showWhile(null, (Runnable)sortRunner);
        return true;
    }
}

