/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.ColorManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIAccess {
    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Display getDisplay(Shell shell) {
        Display display = null;
        if (shell != null) {
            display = shell.getDisplay();
        }
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow(boolean inUIThread) {
        if (inUIThread) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        Display display = UIAccess.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        final AtomicReference windowRef = new AtomicReference();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                windowRef.set(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        });
        return (IWorkbenchWindow)windowRef.get();
    }

    public static IWorkbenchPage getActiveWorkbenchPage(boolean inUIThread) {
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchPart getActiveWorkbenchPart(boolean inUIThread) {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null && (activePage = window.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell(boolean inUIThread) {
        IWorkbenchWindow window = UIAccess.getActiveWorkbenchWindow(inUIThread);
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Color getColor(final ColorManager colorManager, final RGB rgb) {
        final AtomicReference colorRef = new AtomicReference();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                colorRef.set(colorManager.getColor(rgb));
            }
        });
        return (Color)colorRef.get();
    }

    public static void checkedSyncExec(final CheckedRunnable runnable) throws CoreException {
        final AtomicReference error = new AtomicReference();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (CoreException e) {
                    error.set(e);
                }
            }
        });
        if (error.get() != null) {
            throw (CoreException)((Object)error.get());
        }
    }

    @NonNullByDefault(value={NullDefaultLocation.PARAMETER})
    public static <T> T syncExecGet(Supplier<T> getter) {
        class GetRunnable
        implements Runnable {
            volatile T value;
            private final /* synthetic */ Supplier val$getter;

            GetRunnable(Supplier supplier) {
                this.val$getter = supplier;
            }

            @Override
            public void run() {
                this.value = this.val$getter.get();
            }
        }
        GetRunnable runnable = new GetRunnable(getter);
        UIAccess.getDisplay().syncExec((Runnable)runnable);
        return runnable.value;
    }

    public static final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    public static final boolean isOkToUse(Viewer viewer) {
        Control control;
        return viewer != null && (control = viewer.getControl()) != null && !control.isDisposed() && Display.getCurrent() != null;
    }

    private UIAccess() {
    }

    public static interface CheckedRunnable {
        public void run() throws CoreException;
    }
}

